/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.experimental.smt;

import firrtl.MemoryInitValue;
import firrtl.backends.experimental.smt.BVExpr;
import firrtl.backends.experimental.smt.BVIte;
import firrtl.backends.experimental.smt.BVSymbol;
import firrtl.backends.experimental.smt.MemoryEncoding;
import firrtl.backends.experimental.smt.ModuleScanner;
import firrtl.backends.experimental.smt.MultiClockException;
import firrtl.backends.experimental.smt.SMTExpr;
import firrtl.backends.experimental.smt.Signal;
import firrtl.backends.experimental.smt.State;
import firrtl.backends.experimental.smt.TransitionSystem;
import firrtl.ir.DefMemory;
import firrtl.ir.FileInfo;
import firrtl.ir.Info;
import firrtl.ir.Module;
import firrtl.ir.MultiInfo;
import firrtl.ir.NoInfo$;
import firrtl.ir.Port;
import firrtl.ir.Statement;
import java.io.Serializable;
import logger.LazyLogging;
import logger.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\b\u0010\taAQ!\n\u0001\u0005\u0002\u0019BQ!\u000b\u0001\u0005\u0002)Bqa\u0014\u0001\u0012\u0002\u0013\u0005\u0001\u000bC\u0004\\\u0001E\u0005I\u0011\u0001/\t\u000by\u0003A\u0011B0\t\u000fQ\u0004!\u0019!C\u0005k\"1Q\u0010\u0001Q\u0001\nYDqA \u0001C\u0002\u0013%Q\u000f\u0003\u0004\u0000\u0001\u0001\u0006IA\u001e\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011)\t)\u0002\u0001b\u0001\n\u0003)\u0012q\u0003\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u001a!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\"\u0001G'pIVdW\rV8Ue\u0006t7/\u001b;j_:\u001c\u0016p\u001d;f[*\u0011\u0001#E\u0001\u0004g6$(B\u0001\n\u0014\u00031)\u0007\u0010]3sS6,g\u000e^1m\u0015\t!R#\u0001\u0005cC\u000e\\WM\u001c3t\u0015\u00051\u0012A\u00024jeJ$Hn\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\rj\u0011!\t\u0006\u0002E\u00051An\\4hKJL!\u0001J\u0011\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003=\t1A];o)\u0011YcF\u000e$\u0011\u0005!b\u0013BA\u0017\u0010\u0005A!&/\u00198tSRLwN\\*zgR,W\u000eC\u00030\u0005\u0001\u0007\u0001'A\u0001n!\t\tD'D\u00013\u0015\t\u0019T#\u0001\u0002je&\u0011QG\r\u0002\u0007\u001b>$W\u000f\\3\t\u000f]\u0012\u0001\u0013!a\u0001q\u0005Q\u0001O]3tKR\u0014VmZ:\u0011\u0007e\u00025I\u0004\u0002;}A\u00111hG\u0007\u0002y)\u0011QhF\u0001\u0007yI|w\u000e\u001e \n\u0005}Z\u0012A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n\u00191+\u001a;\u000b\u0005}Z\u0002CA\u001dE\u0013\t)%I\u0001\u0004TiJLgn\u001a\u0005\b\u000f\n\u0001\n\u00111\u0001I\u0003\u001diW-\\%oSR\u0004B!O%D\u0017&\u0011!J\u0011\u0002\u0004\u001b\u0006\u0004\bC\u0001'N\u001b\u0005)\u0012B\u0001(\u0016\u0005=iU-\\8ss&s\u0017\u000e\u001e,bYV,\u0017!\u0004:v]\u0012\"WMZ1vYR$#'F\u0001RU\tA$kK\u0001T!\t!\u0016,D\u0001V\u0015\t1v+A\u0005v]\u000eDWmY6fI*\u0011\u0001lG\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001.V\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eeVtG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003uS#\u0001\u0013*\u0002\u0015=t'+Z4jgR,'\u000fF\u0004aG\u0016Tw.]:\u0011\u0005!\n\u0017B\u00012\u0010\u0005\u0015\u0019F/\u0019;f\u0011\u0015!W\u00011\u0001D\u0003\u0011q\u0017-\\3\t\u000b\u0019,\u0001\u0019A4\u0002\u000b]LG\r\u001e5\u0011\u0005iA\u0017BA5\u001c\u0005\rIe\u000e\u001e\u0005\u0006W\u0016\u0001\r\u0001\\\u0001\ne\u0016\u001cX\r^#yaJ\u0004\"\u0001K7\n\u00059|!A\u0002\"W\u000bb\u0004(\u000fC\u0003q\u000b\u0001\u0007A.\u0001\u0005j]&$X\t\u001f9s\u0011\u0015\u0011X\u00011\u0001m\u0003!qW\r\u001f;FqB\u0014\b\"B\u001c\u0006\u0001\u0004A\u0014!D%oM>\u001cV\r]1sCR|'/F\u0001w!\t9H0D\u0001y\u0015\tI(0\u0001\u0003mC:<'\"A>\u0002\t)\fg/Y\u0005\u0003\u000bb\fa\"\u00138g_N+\u0007/\u0019:bi>\u0014\b%\u0001\u0006J]\u001a|\u0007K]3gSb\f1\"\u00138g_B\u0013XMZ5yA\u0005i1/\u001a:jC2L'0Z%oM>$B!!\u0002\u0002\fA!!$a\u0002D\u0013\r\tIa\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u00055!\u00021\u0001\u0002\u0010\u0005!\u0011N\u001c4p!\r\t\u0014\u0011C\u0005\u0004\u0003'\u0011$\u0001B%oM>\fqA]1oI>l7/\u0006\u0002\u0002\u001aA9\u00111DA\u0013\u0007\u0006%RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u000f5,H/\u00192mK*\u0019\u00111E\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002(\u0005u!!\u0004'j].,G\rS1tQ6\u000b\u0007\u000fE\u0002)\u0003WI1!!\f\u0010\u0005!\u0011ekU=nE>d\u0017\u0001\u0003:b]\u0012|Wn\u001d\u0011\u0002\u00155\f7.\u001a*b]\u0012|W\u000eF\u0003m\u0003k\tI\u0004\u0003\u0004\u000285\u0001\raQ\u0001\tE\u0006\u001cXMT1nK\")a-\u0004a\u0001O\u0002")
public class ModuleToTransitionSystem
implements LazyLogging {
    private final String InfoSeparator;
    private final String InfoPrefix;
    private final LinkedHashMap<String, BVSymbol> randoms;
    private final Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public TransitionSystem run(Module m2, Set<String> presetRegs, Map<String, MemoryInitValue> memInit) {
        ModuleScanner scan = new ModuleScanner((Function2<String, Object, BVExpr> & Serializable & scala.Serializable)(baseName, width) -> this.makeRandom(baseName, BoxesRunTime.unboxToInt(width)));
        m2.foreachPort((Function1<Port, BoxedUnit>)(Function1<Port, Object> & Serializable & scala.Serializable)p -> {
            scan.onPort(p);
            return BoxedUnit.UNIT;
        });
        m2.foreachStmt((Function1<Statement, BoxedUnit>)(Function1<Statement, Object> & Serializable & scala.Serializable)s -> {
            scan.onStatement(s);
            return BoxedUnit.UNIT;
        });
        if (scan.clocks().size() > 1) {
            throw new MultiClockException(new StringBuilder(37).append("The module ").append(m2.name()).append(" has more than one clock: ").append(scan.clocks().mkString(", ")).toString());
        }
        GenSet outputs = scan.outputs().toSet();
        GenSet constraints = scan.assumes().toSet();
        GenSet bad = scan.asserts().toSet();
        Set isSignal = (Set)scan.wires().$plus$plus(scan.nodes()).$plus$plus(scan.memSignals()).toSet().$plus$plus(outputs).$plus$plus(constraints).$plus$plus(bad);
        ArrayBuffer<?> signals = ((TraversableLike)scan.connects().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ModuleToTransitionSystem.$anonfun$run$4(isSignal, x0$1)))).map((Function1<Tuple2, Signal> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            BVExpr expr = (BVExpr)tuple2._2();
            Signal signal = new Signal(name, expr);
            return signal;
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        Map registers = ((TraversableOnce)scan.registers().map((Function1<Tuple4, Tuple2> & Serializable & scala.Serializable)r -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(r._1()), r), ArrayBuffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ArrayBuffer regStates = ((TraversableLike)scan.connects().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean(registers.contains(s._1())))).map((Function1<Tuple2, State> & Serializable & scala.Serializable)x0$3 -> {
            Tuple3<Integer, BVExpr, BVExpr> tuple3;
            BVExpr nextExpr;
            String name;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                name = (String)tuple2._1();
                nextExpr = (BVExpr)tuple2._2();
                Tuple4 tuple4 = (Tuple4)registers.apply(name);
                if (tuple4 == null) {
                    throw new MatchError(tuple4);
                }
                int width = BoxesRunTime.unboxToInt(tuple4._2());
                BVExpr resetExpr = (BVExpr)tuple4._3();
                BVExpr initExpr = (BVExpr)tuple4._4();
                tuple3 = new Tuple3<Integer, BVExpr, BVExpr>(BoxesRunTime.boxToInteger(width), resetExpr, initExpr);
            } else {
                throw new MatchError(tuple2);
            }
            Tuple3<Integer, BVExpr, BVExpr> tuple32 = tuple3;
            int width = BoxesRunTime.unboxToInt(tuple32._1());
            BVExpr resetExpr = tuple32._2();
            BVExpr initExpr = tuple32._3();
            State state = this.onRegister(name, width, resetExpr, initExpr, nextExpr, presetRegs);
            return state;
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        MemoryEncoding memoryEncoding = new MemoryEncoding((Function2<String, Object, BVExpr> & Serializable & scala.Serializable)(baseName, width) -> this.makeRandom(baseName, BoxesRunTime.unboxToInt(width)), scan.namespace());
        ArrayBuffer<?> memoryStatesAndOutputs = scan.memories().map((Function1<DefMemory, Tuple2> & Serializable & scala.Serializable)m -> memoryEncoding.onMemory((DefMemory)m, (Iterable<Tuple2<String, BVExpr>>)scan.connects(), memInit.get(m.name())), ArrayBuffer$.MODULE$.canBuildFrom());
        Map memOutputs = ((TraversableOnce)memoryStatesAndOutputs.flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x$4 -> (Iterable)x$4._2(), ArrayBuffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ArrayBuffer signalsWithMem = (ArrayBuffer)((TraversableLike)signals.map((Function1<Signal, Signal> & Serializable & scala.Serializable)s -> {
            Signal signal;
            if (memOutputs.contains(s.name())) {
                BVExpr x$1 = (BVExpr)memOutputs.apply(s.name());
                String x$2 = s.copy$default$1();
                signal = s.copy(x$2, x$1);
            } else {
                signal = s;
            }
            return signal;
        }, ArrayBuffer$.MODULE$.canBuildFrom())).filter((Function1<Signal, Object> & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean(ModuleToTransitionSystem.$anonfun$run$13(s)));
        State[] states = (State[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])regStates.toArray(ClassTag$.MODULE$.apply(State.class)))).$plus$plus((GenTraversableOnce)memoryStatesAndOutputs.flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x$5 -> (Iterable)x$5._1(), ArrayBuffer$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(State.class)));
        HashMap comments = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        scan.infos().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$4 -> {
            ModuleToTransitionSystem.$anonfun$run$15(this, comments, x0$4);
            return BoxedUnit.UNIT;
        });
        ArrayBuffer inputs = (ArrayBuffer)scan.inputs().$plus$plus(this.randoms().values());
        String[] header = (String[])Option$.MODULE$.option2Iterable(this.serializeInfo(m2.info()).map((Function1<String, String> & Serializable & scala.Serializable)x$6 -> new StringBuilder(0).append(this.InfoPrefix()).append((String)x$6).toString())).toArray(ClassTag$.MODULE$.apply(String.class));
        Set fair = (Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$);
        return new TransitionSystem(m2.name(), (BVSymbol[])inputs.toArray(ClassTag$.MODULE$.apply(BVSymbol.class)), states, (Signal[])signalsWithMem.toArray(ClassTag$.MODULE$.apply(Signal.class)), (Set<String>)outputs, (Set<String>)constraints, (Set<String>)bad, fair, (Map<String, String>)comments.toMap(Predef$.MODULE$.$conforms()), header);
    }

    public Set<String> run$default$2() {
        return (Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$);
    }

    public Map<String, MemoryInitValue> run$default$3() {
        return (Map)Predef$.MODULE$.Map().apply(Nil$.MODULE$);
    }

    private State onRegister(String name, int width, BVExpr resetExpr, BVExpr initExpr, BVExpr nextExpr, Set<String> presetRegs) {
        State state;
        Predef$.MODULE$.assert(initExpr.width() == width);
        Predef$.MODULE$.assert(nextExpr.width() == width);
        Predef$.MODULE$.assert(resetExpr.width() == 1);
        BVSymbol sym = new BVSymbol(name, width);
        BVExpr bVExpr = initExpr;
        BVSymbol bVSymbol = sym;
        boolean hasReset = bVExpr == null ? bVSymbol != null : !bVExpr.equals(bVSymbol);
        boolean isPreset = presetRegs.contains(name);
        Predef$.MODULE$.assert(!isPreset || hasReset, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Expected preset register ").append(name).append(" to have a reset value, not just ").append(initExpr).append("!").toString());
        if (hasReset) {
            Option init = isPreset ? new Some<BVExpr>(initExpr) : None$.MODULE$;
            BVExpr next = isPreset ? nextExpr : new BVIte(resetExpr, initExpr, nextExpr);
            BVSymbol x$1 = sym;
            Some<SMTExpr> x$2 = new Some<SMTExpr>(next);
            Option x$3 = init;
            state = new State(x$1, x$3, x$2);
        } else {
            BVSymbol x$4 = sym;
            Some<SMTExpr> x$5 = new Some<SMTExpr>(nextExpr);
            None$ x$6 = None$.MODULE$;
            state = new State(x$4, x$6, x$5);
        }
        return state;
    }

    private String InfoSeparator() {
        return this.InfoSeparator;
    }

    private String InfoPrefix() {
        return this.InfoPrefix;
    }

    private Option<String> serializeInfo(Info info) {
        Option option;
        Info info2 = info;
        if (NoInfo$.MODULE$.equals(info2)) {
            option = None$.MODULE$;
        } else if (info2 instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)info2;
            option = new Some<String>(fileInfo.escaped());
        } else if (info2 instanceof MultiInfo) {
            MultiInfo multiInfo = (MultiInfo)info2;
            Seq<FileInfo> infos = multiInfo.flatten();
            option = infos.isEmpty() ? None$.MODULE$ : new Some<String>(((TraversableOnce)infos.map((Function1<FileInfo, String> & Serializable & scala.Serializable)x$7 -> x$7.escaped(), Seq$.MODULE$.canBuildFrom())).mkString(this.InfoSeparator()));
        } else {
            throw new MatchError(info2);
        }
        return option;
    }

    public LinkedHashMap<String, BVSymbol> randoms() {
        return this.randoms;
    }

    private BVExpr makeRandom(String baseName, int width) {
        Iterator suffixes = package$.MODULE$.Iterator().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{baseName})).$plus$plus((Function0<IndexedSeq> & Serializable & scala.Serializable)() -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).map((Function1<Object, String> & Serializable & scala.Serializable)ii -> ModuleToTransitionSystem.$anonfun$makeRandom$2(baseName, BoxesRunTime.unboxToInt(ii)), IndexedSeq$.MODULE$.canBuildFrom()));
        String name = (String)suffixes.map((Function1<String, String> & Serializable & scala.Serializable)s -> new StringBuilder(7).append("RANDOM.").append((String)s).toString()).find((Function1<String, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(ModuleToTransitionSystem.$anonfun$makeRandom$4(this, x$8))).get();
        BVSymbol sym = new BVSymbol(name, width);
        this.randoms().update(name, sym);
        return sym;
    }

    public static final /* synthetic */ boolean $anonfun$run$4(Set isSignal$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String name = (String)tuple2._1();
        boolean bl = isSignal$1.contains(name);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$run$13(Signal s) {
        Signal signal = s;
        if (signal == null) return true;
        String n0 = signal.name();
        BVExpr bVExpr = signal.e();
        if (!(bVExpr instanceof BVSymbol)) return true;
        BVSymbol bVSymbol = (BVSymbol)bVExpr;
        String n1 = bVSymbol.name();
        String string = n0;
        String string2 = n1;
        if (string != null) {
            if (!string.equals(string2)) return true;
            return false;
        }
        if (string2 == null) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$run$16(ModuleToTransitionSystem $this, HashMap comments$1, String name$1, String infoString) {
        if (comments$1.contains(name$1)) {
            comments$1.update(name$1, new StringBuilder(0).append((String)comments$1.apply(name$1)).append($this.InfoSeparator()).append(infoString).toString());
        } else {
            comments$1.update(name$1, new StringBuilder(0).append($this.InfoPrefix()).append(infoString).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$run$15(ModuleToTransitionSystem $this, HashMap comments$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String name = (String)tuple2._1();
        Info info = (Info)tuple2._2();
        $this.serializeInfo(info).foreach((Function1<String, Object> & Serializable & scala.Serializable)infoString -> {
            ModuleToTransitionSystem.$anonfun$run$16($this, comments$1, name, infoString);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$makeRandom$2(String baseName$1, int ii) {
        return new StringBuilder(1).append(baseName$1).append("_").append(ii).toString();
    }

    public static final /* synthetic */ boolean $anonfun$makeRandom$4(ModuleToTransitionSystem $this, String x$8) {
        return !$this.randoms().contains(x$8);
    }

    public ModuleToTransitionSystem() {
        LazyLogging.$init$(this);
        this.InfoSeparator = ", ";
        this.InfoPrefix = "@ ";
        this.randoms = (LinkedHashMap)LinkedHashMap$.MODULE$.apply(Nil$.MODULE$);
    }
}

