/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.experimental.smt;

import firrtl.backends.experimental.smt.ArrayConstant;
import firrtl.backends.experimental.smt.ArrayEqual;
import firrtl.backends.experimental.smt.ArrayExpr;
import firrtl.backends.experimental.smt.ArrayIte;
import firrtl.backends.experimental.smt.ArrayRawExpr;
import firrtl.backends.experimental.smt.ArrayRead;
import firrtl.backends.experimental.smt.ArrayStore;
import firrtl.backends.experimental.smt.ArraySymbol;
import firrtl.backends.experimental.smt.BVComparison;
import firrtl.backends.experimental.smt.BVConcat;
import firrtl.backends.experimental.smt.BVEqual;
import firrtl.backends.experimental.smt.BVExpr;
import firrtl.backends.experimental.smt.BVExtend;
import firrtl.backends.experimental.smt.BVImplies;
import firrtl.backends.experimental.smt.BVIte;
import firrtl.backends.experimental.smt.BVLiteral;
import firrtl.backends.experimental.smt.BVNegate;
import firrtl.backends.experimental.smt.BVNot;
import firrtl.backends.experimental.smt.BVOp;
import firrtl.backends.experimental.smt.BVRawExpr;
import firrtl.backends.experimental.smt.BVReduceAnd;
import firrtl.backends.experimental.smt.BVReduceOr;
import firrtl.backends.experimental.smt.BVReduceXor;
import firrtl.backends.experimental.smt.BVSlice;
import firrtl.backends.experimental.smt.BVSymbol;
import firrtl.backends.experimental.smt.SMTExpr;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;

public final class SMTExprVisitor$ {
    public static SMTExprVisitor$ MODULE$;

    static {
        new SMTExprVisitor$();
    }

    public <T extends SMTExpr> T map(Function1<BVExpr, BVExpr> bv, Function1<ArrayExpr, ArrayExpr> ar, T e) {
        SMTExpr sMTExpr;
        T t = e;
        if (t instanceof BVExpr) {
            T t2 = t;
            sMTExpr = this.map((BVExpr)t2, bv, ar);
        } else if (t instanceof ArrayExpr) {
            T t3 = t;
            sMTExpr = this.map((ArrayExpr)t3, bv, ar);
        } else {
            throw new MatchError(t);
        }
        return (T)sMTExpr;
    }

    public <T extends SMTExpr> T map(Function1<SMTExpr, SMTExpr> f, T e) {
        return this.map((Function1<BVExpr, BVExpr> & Serializable & scala.Serializable)(BVExpr b) -> (BVExpr)f.apply((SMTExpr)b), (Function1<ArrayExpr, ArrayExpr> & Serializable & scala.Serializable)(ArrayExpr a) -> (ArrayExpr)f.apply((SMTExpr)a), e);
    }

    private BVExpr map(BVExpr e, Function1<BVExpr, BVExpr> bv, Function1<ArrayExpr, ArrayExpr> ar) {
        BVExpr bVExpr;
        BVExpr bVExpr2 = e;
        if (bVExpr2 instanceof BVLiteral) {
            BVLiteral bVLiteral = (BVLiteral)bVExpr2;
            bVExpr = bv.apply(bVLiteral);
        } else if (bVExpr2 instanceof BVSymbol) {
            BVSymbol bVSymbol = (BVSymbol)bVExpr2;
            bVExpr = bv.apply(bVSymbol);
        } else if (bVExpr2 instanceof BVRawExpr) {
            BVRawExpr bVRawExpr = (BVRawExpr)bVExpr2;
            bVExpr = bv.apply(bVRawExpr);
        } else if (bVExpr2 instanceof BVExtend) {
            BVExtend bVExtend = (BVExtend)bVExpr2;
            BVExpr e2 = bVExtend.e();
            int by = bVExtend.by();
            boolean signed = bVExtend.signed();
            BVExpr n = this.map(e2, bv, ar);
            bVExpr = bv.apply(n == e2 ? bVExtend : new BVExtend(n, by, signed));
        } else if (bVExpr2 instanceof BVSlice) {
            BVSlice bVSlice = (BVSlice)bVExpr2;
            BVExpr e3 = bVSlice.e();
            int hi = bVSlice.hi();
            int lo = bVSlice.lo();
            BVExpr n = this.map(e3, bv, ar);
            bVExpr = bv.apply(n == e3 ? bVSlice : new BVSlice(n, hi, lo));
        } else if (bVExpr2 instanceof BVNot) {
            BVNot bVNot = (BVNot)bVExpr2;
            BVExpr e4 = bVNot.e();
            BVExpr n = this.map(e4, bv, ar);
            bVExpr = bv.apply(n == e4 ? bVNot : new BVNot(n));
        } else if (bVExpr2 instanceof BVNegate) {
            BVNegate bVNegate = (BVNegate)bVExpr2;
            BVExpr e5 = bVNegate.e();
            BVExpr n = this.map(e5, bv, ar);
            bVExpr = bv.apply(n == e5 ? bVNegate : new BVNegate(n));
        } else if (bVExpr2 instanceof BVReduceAnd) {
            BVReduceAnd bVReduceAnd = (BVReduceAnd)bVExpr2;
            BVExpr e6 = bVReduceAnd.e();
            BVExpr n = this.map(e6, bv, ar);
            bVExpr = bv.apply(n == e6 ? bVReduceAnd : new BVReduceAnd(n));
        } else if (bVExpr2 instanceof BVReduceOr) {
            BVReduceOr bVReduceOr = (BVReduceOr)bVExpr2;
            BVExpr e7 = bVReduceOr.e();
            BVExpr n = this.map(e7, bv, ar);
            bVExpr = bv.apply(n == e7 ? bVReduceOr : new BVReduceOr(n));
        } else if (bVExpr2 instanceof BVReduceXor) {
            BVReduceXor bVReduceXor = (BVReduceXor)bVExpr2;
            BVExpr e8 = bVReduceXor.e();
            BVExpr n = this.map(e8, bv, ar);
            bVExpr = bv.apply(n == e8 ? bVReduceXor : new BVReduceXor(n));
        } else if (bVExpr2 instanceof BVImplies) {
            BVImplies bVImplies = (BVImplies)bVExpr2;
            BVExpr a = bVImplies.a();
            BVExpr b = bVImplies.b();
            Tuple2<BVExpr, BVExpr> tuple2 = new Tuple2<BVExpr, BVExpr>(this.map(a, bv, ar), this.map(b, bv, ar));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            BVExpr nA = tuple2._1();
            BVExpr nB = tuple2._2();
            Tuple2<BVExpr, BVExpr> tuple22 = new Tuple2<BVExpr, BVExpr>(nA, nB);
            Tuple2<BVExpr, BVExpr> tuple23 = tuple22;
            BVExpr nA2 = tuple23._1();
            BVExpr nB2 = tuple23._2();
            bVExpr = bv.apply(nA2 == a && nB2 == b ? bVImplies : new BVImplies(nA2, nB2));
        } else if (bVExpr2 instanceof BVEqual) {
            BVEqual bVEqual = (BVEqual)bVExpr2;
            BVExpr a = bVEqual.a();
            BVExpr b = bVEqual.b();
            Tuple2<BVExpr, BVExpr> tuple2 = new Tuple2<BVExpr, BVExpr>(this.map(a, bv, ar), this.map(b, bv, ar));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            BVExpr nA = tuple2._1();
            BVExpr nB = tuple2._2();
            Tuple2<BVExpr, BVExpr> tuple24 = new Tuple2<BVExpr, BVExpr>(nA, nB);
            Tuple2<BVExpr, BVExpr> tuple25 = tuple24;
            BVExpr nA3 = tuple25._1();
            BVExpr nB3 = tuple25._2();
            bVExpr = bv.apply(nA3 == a && nB3 == b ? bVEqual : new BVEqual(nA3, nB3));
        } else if (bVExpr2 instanceof ArrayEqual) {
            ArrayEqual arrayEqual = (ArrayEqual)bVExpr2;
            ArrayExpr a = arrayEqual.a();
            ArrayExpr b = arrayEqual.b();
            Tuple2<ArrayExpr, ArrayExpr> tuple2 = new Tuple2<ArrayExpr, ArrayExpr>(this.map(a, bv, ar), this.map(b, bv, ar));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ArrayExpr nA = tuple2._1();
            ArrayExpr nB = tuple2._2();
            Tuple2<ArrayExpr, ArrayExpr> tuple26 = new Tuple2<ArrayExpr, ArrayExpr>(nA, nB);
            Tuple2<ArrayExpr, ArrayExpr> tuple27 = tuple26;
            ArrayExpr nA4 = tuple27._1();
            ArrayExpr nB4 = tuple27._2();
            bVExpr = bv.apply(nA4 == a && nB4 == b ? arrayEqual : new ArrayEqual(nA4, nB4));
        } else if (bVExpr2 instanceof BVComparison) {
            BVComparison bVComparison = (BVComparison)bVExpr2;
            Enumeration.Value op = bVComparison.op();
            BVExpr a = bVComparison.a();
            BVExpr b = bVComparison.b();
            boolean signed = bVComparison.signed();
            Tuple2<BVExpr, BVExpr> tuple2 = new Tuple2<BVExpr, BVExpr>(this.map(a, bv, ar), this.map(b, bv, ar));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            BVExpr nA = tuple2._1();
            BVExpr nB = tuple2._2();
            Tuple2<BVExpr, BVExpr> tuple28 = new Tuple2<BVExpr, BVExpr>(nA, nB);
            Tuple2<BVExpr, BVExpr> tuple29 = tuple28;
            BVExpr nA5 = tuple29._1();
            BVExpr nB5 = tuple29._2();
            bVExpr = bv.apply(nA5 == a && nB5 == b ? bVComparison : new BVComparison(op, nA5, nB5, signed));
        } else if (bVExpr2 instanceof BVOp) {
            BVOp bVOp = (BVOp)bVExpr2;
            Enumeration.Value op = bVOp.op();
            BVExpr a = bVOp.a();
            BVExpr b = bVOp.b();
            Tuple2<BVExpr, BVExpr> tuple2 = new Tuple2<BVExpr, BVExpr>(this.map(a, bv, ar), this.map(b, bv, ar));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            BVExpr nA = tuple2._1();
            BVExpr nB = tuple2._2();
            Tuple2<BVExpr, BVExpr> tuple210 = new Tuple2<BVExpr, BVExpr>(nA, nB);
            Tuple2<BVExpr, BVExpr> tuple211 = tuple210;
            BVExpr nA6 = tuple211._1();
            BVExpr nB6 = tuple211._2();
            bVExpr = bv.apply(nA6 == a && nB6 == b ? bVOp : new BVOp(op, nA6, nB6));
        } else if (bVExpr2 instanceof BVConcat) {
            BVConcat bVConcat = (BVConcat)bVExpr2;
            BVExpr a = bVConcat.a();
            BVExpr b = bVConcat.b();
            Tuple2<BVExpr, BVExpr> tuple2 = new Tuple2<BVExpr, BVExpr>(this.map(a, bv, ar), this.map(b, bv, ar));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            BVExpr nA = tuple2._1();
            BVExpr nB = tuple2._2();
            Tuple2<BVExpr, BVExpr> tuple212 = new Tuple2<BVExpr, BVExpr>(nA, nB);
            Tuple2<BVExpr, BVExpr> tuple213 = tuple212;
            BVExpr nA7 = tuple213._1();
            BVExpr nB7 = tuple213._2();
            bVExpr = bv.apply(nA7 == a && nB7 == b ? bVConcat : new BVConcat(nA7, nB7));
        } else if (bVExpr2 instanceof ArrayRead) {
            ArrayRead arrayRead = (ArrayRead)bVExpr2;
            ArrayExpr a = arrayRead.array();
            BVExpr b = arrayRead.index();
            Tuple2<ArrayExpr, BVExpr> tuple2 = new Tuple2<ArrayExpr, BVExpr>(this.map(a, bv, ar), this.map(b, bv, ar));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ArrayExpr nA = tuple2._1();
            BVExpr nB = tuple2._2();
            Tuple2<ArrayExpr, BVExpr> tuple214 = new Tuple2<ArrayExpr, BVExpr>(nA, nB);
            Tuple2<ArrayExpr, BVExpr> tuple215 = tuple214;
            ArrayExpr nA8 = tuple215._1();
            BVExpr nB8 = tuple215._2();
            bVExpr = bv.apply(nA8 == a && nB8 == b ? arrayRead : new ArrayRead(nA8, nB8));
        } else if (bVExpr2 instanceof BVIte) {
            BVIte bVIte = (BVIte)bVExpr2;
            BVExpr a = bVIte.cond();
            BVExpr b = bVIte.tru();
            BVExpr c = bVIte.fals();
            Tuple3<BVExpr, BVExpr, BVExpr> tuple3 = new Tuple3<BVExpr, BVExpr, BVExpr>(this.map(a, bv, ar), this.map(b, bv, ar), this.map(c, bv, ar));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            BVExpr nA = tuple3._1();
            BVExpr nB = tuple3._2();
            BVExpr nC = tuple3._3();
            Tuple3<BVExpr, BVExpr, BVExpr> tuple32 = new Tuple3<BVExpr, BVExpr, BVExpr>(nA, nB, nC);
            Tuple3<BVExpr, BVExpr, BVExpr> tuple33 = tuple32;
            BVExpr nA9 = tuple33._1();
            BVExpr nB9 = tuple33._2();
            BVExpr nC2 = tuple33._3();
            bVExpr = bv.apply(nA9 == a && nB9 == b && nC2 == c ? bVIte : new BVIte(nA9, nB9, nC2));
        } else {
            throw new MatchError(bVExpr2);
        }
        return bVExpr;
    }

    private ArrayExpr map(ArrayExpr e, Function1<BVExpr, BVExpr> bv, Function1<ArrayExpr, ArrayExpr> ar) {
        ArrayExpr arrayExpr;
        ArrayExpr arrayExpr2 = e;
        if (arrayExpr2 instanceof ArrayRawExpr) {
            ArrayRawExpr arrayRawExpr = (ArrayRawExpr)arrayExpr2;
            arrayExpr = ar.apply(arrayRawExpr);
        } else if (arrayExpr2 instanceof ArraySymbol) {
            ArraySymbol arraySymbol = (ArraySymbol)arrayExpr2;
            arrayExpr = ar.apply(arraySymbol);
        } else if (arrayExpr2 instanceof ArrayConstant) {
            ArrayConstant arrayConstant = (ArrayConstant)arrayExpr2;
            BVExpr e2 = arrayConstant.e();
            int indexWidth = arrayConstant.indexWidth();
            BVExpr n = this.map(e2, bv, ar);
            arrayExpr = ar.apply(n == e2 ? arrayConstant : new ArrayConstant(n, indexWidth));
        } else if (arrayExpr2 instanceof ArrayStore) {
            ArrayStore arrayStore = (ArrayStore)arrayExpr2;
            ArrayExpr a = arrayStore.array();
            BVExpr b = arrayStore.index();
            BVExpr c = arrayStore.data();
            Tuple3<ArrayExpr, BVExpr, BVExpr> tuple3 = new Tuple3<ArrayExpr, BVExpr, BVExpr>(this.map(a, bv, ar), this.map(b, bv, ar), this.map(c, bv, ar));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            ArrayExpr nA = tuple3._1();
            BVExpr nB = tuple3._2();
            BVExpr nC = tuple3._3();
            Tuple3<ArrayExpr, BVExpr, BVExpr> tuple32 = new Tuple3<ArrayExpr, BVExpr, BVExpr>(nA, nB, nC);
            Tuple3<ArrayExpr, BVExpr, BVExpr> tuple33 = tuple32;
            ArrayExpr nA2 = tuple33._1();
            BVExpr nB2 = tuple33._2();
            BVExpr nC2 = tuple33._3();
            arrayExpr = ar.apply(nA2 == a && nB2 == b && nC2 == c ? arrayStore : new ArrayStore(nA2, nB2, nC2));
        } else if (arrayExpr2 instanceof ArrayIte) {
            ArrayIte arrayIte = (ArrayIte)arrayExpr2;
            BVExpr a = arrayIte.cond();
            ArrayExpr b = arrayIte.tru();
            ArrayExpr c = arrayIte.fals();
            Tuple3<BVExpr, ArrayExpr, ArrayExpr> tuple3 = new Tuple3<BVExpr, ArrayExpr, ArrayExpr>(this.map(a, bv, ar), this.map(b, bv, ar), this.map(c, bv, ar));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            BVExpr nA = tuple3._1();
            ArrayExpr nB = tuple3._2();
            ArrayExpr nC = tuple3._3();
            Tuple3<BVExpr, ArrayExpr, ArrayExpr> tuple34 = new Tuple3<BVExpr, ArrayExpr, ArrayExpr>(nA, nB, nC);
            Tuple3<BVExpr, ArrayExpr, ArrayExpr> tuple35 = tuple34;
            BVExpr nA3 = tuple35._1();
            ArrayExpr nB3 = tuple35._2();
            ArrayExpr nC3 = tuple35._3();
            arrayExpr = ar.apply(nA3 == a && nB3 == b && nC3 == c ? arrayIte : new ArrayIte(nA3, nB3, nC3));
        } else {
            throw new MatchError(arrayExpr2);
        }
        return arrayExpr;
    }

    private SMTExprVisitor$() {
        MODULE$ = this;
    }
}

