/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.experimental.smt;

import firrtl.backends.experimental.smt.ArrayRawExpr;
import firrtl.backends.experimental.smt.ArraySymbol;
import firrtl.backends.experimental.smt.BVExpr;
import firrtl.backends.experimental.smt.BVLiteral;
import firrtl.backends.experimental.smt.BVOp;
import firrtl.backends.experimental.smt.BVRawExpr;
import firrtl.backends.experimental.smt.BVSymbol;
import firrtl.backends.experimental.smt.Comment;
import firrtl.backends.experimental.smt.Comment$;
import firrtl.backends.experimental.smt.DeclareFunction;
import firrtl.backends.experimental.smt.DeclareUninterpretedSort;
import firrtl.backends.experimental.smt.DefineFunction;
import firrtl.backends.experimental.smt.Op$;
import firrtl.backends.experimental.smt.SMTCommand;
import firrtl.backends.experimental.smt.SMTEqual$;
import firrtl.backends.experimental.smt.SMTExpr;
import firrtl.backends.experimental.smt.SMTExprVisitor$;
import firrtl.backends.experimental.smt.SMTLibSerializer$;
import firrtl.backends.experimental.smt.SMTSymbol;
import firrtl.backends.experimental.smt.SMTSymbol$;
import firrtl.backends.experimental.smt.Signal;
import firrtl.backends.experimental.smt.State;
import firrtl.backends.experimental.smt.TransitionSystem;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class SMTTransitionSystemEncoder$ {
    public static SMTTransitionSystemEncoder$ MODULE$;
    private final String State;
    private final String StateNext;
    private final String SignalSuffix;
    private final String NextSuffix;
    private final String InitSuffix;

    static {
        new SMTTransitionSystemEncoder$();
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<SMTCommand> encode(TransitionSystem sys) {
        void var2_2;
        ArrayBuffer cmds = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        String name = sys.name();
        cmds.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sys.header())).map(Comment$.MODULE$, Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit())));
        String stateType = this.id(new StringBuilder(2).append(name).append("_s").toString());
        cmds.$plus$eq(new DeclareUninterpretedSort(stateType));
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sys.inputs())).foreach((Function1<BVSymbol, Object> & Serializable & scala.Serializable)i -> {
            this.declare$1(i, "input", cmds, sys, stateType);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sys.states())).foreach((Function1<State, Object> & Serializable & scala.Serializable)s -> {
            this.declare$1(s.sym(), "register", cmds, sys, stateType);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sys.signals())).foreach((Function1<Signal, Object> & Serializable & scala.Serializable)signal -> {
            SMTTransitionSystemEncoder$.$anonfun$encode$4(this, sys, cmds, stateType, signal);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sys.states())).foreach((Function1<State, Object> & Serializable & scala.Serializable)state -> {
            SMTTransitionSystemEncoder$.$anonfun$encode$6(this, cmds, stateType, state);
            return BoxedUnit.UNIT;
        });
        BVExpr[] transitionRelations = (BVExpr[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sys.states())).map((Function1<State, BVExpr> & Serializable & scala.Serializable)state -> {
            SMTExpr newState = MODULE$.symbolToFunApp(state.sym(), MODULE$.SignalSuffix(), MODULE$.StateNext());
            SMTExpr nextOldState = MODULE$.symbolToFunApp(state.sym(), MODULE$.NextSuffix(), MODULE$.State());
            return SMTEqual$.MODULE$.apply(newState, nextOldState);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BVExpr.class)));
        BVExpr transitionExpr = this.replaceSymbols(this.andReduce(Predef$.MODULE$.wrapRefArray((Object[])transitionRelations)));
        cmds.$plus$eq(new DefineFunction(new StringBuilder(2).append(name).append("_t").toString(), new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<String, String>(this.State(), stateType)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<String, String>(this.StateNext(), stateType)), Nil$.MODULE$)), transitionExpr));
        BVExpr[] initRelations = (BVExpr[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sys.states())).filter((Function1<State, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(SMTTransitionSystemEncoder$.$anonfun$encode$10(x$1))))).map((Function1<State, BVExpr> & Serializable & scala.Serializable)state -> {
            SMTExpr stateSignal = MODULE$.symbolToFunApp(state.sym(), MODULE$.SignalSuffix(), MODULE$.State());
            SMTExpr initSignal = MODULE$.symbolToFunApp(state.sym(), MODULE$.InitSuffix(), MODULE$.State());
            return SMTEqual$.MODULE$.apply(stateSignal, initSignal);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BVExpr.class)));
        this.defineConjunction$1(Predef$.MODULE$.wrapRefArray((Object[])initRelations), "_i", name, cmds, stateType);
        BVExpr[] assertions = (BVExpr[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sys.signals())).filter((Function1<Signal, Object> & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean(SMTTransitionSystemEncoder$.$anonfun$encode$12(sys, a))))).map((Function1<Signal, BVExpr> & Serializable & scala.Serializable)a -> MODULE$.replaceSymbols(a.toSymbol()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BVExpr.class)));
        this.defineConjunction$1(Predef$.MODULE$.wrapRefArray((Object[])assertions), "_a", name, cmds, stateType);
        BVExpr[] assumptions = (BVExpr[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sys.signals())).filter((Function1<Signal, Object> & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean(SMTTransitionSystemEncoder$.$anonfun$encode$14(sys, a))))).map((Function1<Signal, BVExpr> & Serializable & scala.Serializable)a -> MODULE$.replaceSymbols(a.toSymbol()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BVExpr.class)));
        this.defineConjunction$1(Predef$.MODULE$.wrapRefArray((Object[])assumptions), "_u", name, cmds, stateType);
        return var2_2;
    }

    private String id(String s) {
        return SMTLibSerializer$.MODULE$.escapeIdentifier(s);
    }

    private String State() {
        return this.State;
    }

    private String StateNext() {
        return this.StateNext;
    }

    private String SignalSuffix() {
        return this.SignalSuffix;
    }

    private String NextSuffix() {
        return this.NextSuffix;
    }

    private String InitSuffix() {
        return this.InitSuffix;
    }

    private List<Comment> toDescription(SMTSymbol sym, String kind, Function1<String, Option<String>> comments) {
        Comment comment;
        SMTSymbol sMTSymbol = sym;
        if (sMTSymbol instanceof BVSymbol) {
            BVSymbol bVSymbol = (BVSymbol)sMTSymbol;
            String name = bVSymbol.name();
            int width = bVSymbol.width();
            comment = new Comment(new StringBuilder(14).append("firrtl-smt2-").append(kind).append(" ").append(name).append(" ").append(width).toString());
        } else if (sMTSymbol instanceof ArraySymbol) {
            ArraySymbol arraySymbol = (ArraySymbol)sMTSymbol;
            String name = arraySymbol.name();
            int indexWidth = arraySymbol.indexWidth();
            int dataWidth = arraySymbol.dataWidth();
            comment = new Comment(new StringBuilder(15).append("firrtl-smt2-").append(kind).append(" ").append(name).append(" ").append(indexWidth).append(" ").append(dataWidth).toString());
        } else {
            throw new MatchError(sMTSymbol);
        }
        return new $colon$colon<Nothing$>((Nothing$)((Object)comment), Nil$.MODULE$).$plus$plus((GenTraversableOnce<Nothing$>)Option$.MODULE$.option2Iterable(comments.apply(sym.name()).map(Comment$.MODULE$)), List$.MODULE$.canBuildFrom());
    }

    private BVExpr andReduce(Iterable<BVExpr> e) {
        return e.isEmpty() ? new BVLiteral(BigInt$.MODULE$.int2bigInt(1), 1) : (BVExpr)e.reduce((Function2<BVExpr, BVExpr, BVOp> & Serializable & scala.Serializable)(a, b) -> new BVOp(Op$.MODULE$.And(), (BVExpr)a, (BVExpr)b));
    }

    private SMTExpr replaceSymbols(SMTExpr e) {
        return SMTExprVisitor$.MODULE$.map((Function1<SMTExpr, SMTExpr> & Serializable & scala.Serializable)x$2 -> MODULE$.symbolToFunApp((SMTExpr)x$2, MODULE$.SignalSuffix(), MODULE$.State()), e);
    }

    private BVExpr replaceSymbols(BVExpr e) {
        return (BVExpr)this.replaceSymbols((SMTExpr)e);
    }

    private SMTExpr symbolToFunApp(SMTExpr sym, String suffix, String arg) {
        SMTExpr sMTExpr;
        SMTExpr sMTExpr2 = sym;
        if (sMTExpr2 instanceof BVSymbol) {
            BVSymbol bVSymbol = (BVSymbol)sMTExpr2;
            String name = bVSymbol.name();
            int width = bVSymbol.width();
            sMTExpr = new BVRawExpr(new StringBuilder(3).append("(").append(this.id(new StringBuilder(0).append(name).append(suffix).toString())).append(" ").append(arg).append(")").toString(), width);
        } else if (sMTExpr2 instanceof ArraySymbol) {
            ArraySymbol arraySymbol = (ArraySymbol)sMTExpr2;
            String name = arraySymbol.name();
            int indexWidth = arraySymbol.indexWidth();
            int dataWidth = arraySymbol.dataWidth();
            sMTExpr = new ArrayRawExpr(new StringBuilder(3).append("(").append(this.id(new StringBuilder(0).append(name).append(suffix).toString())).append(" ").append(arg).append(")").toString(), indexWidth, dataWidth);
        } else {
            sMTExpr = sMTExpr2;
        }
        return sMTExpr;
    }

    private final void declare$1(SMTSymbol sym, String kind, ArrayBuffer cmds$1, TransitionSystem sys$1, String stateType$1) {
        cmds$1.$plus$plus$eq((TraversableOnce)this.toDescription(sym, kind, (Function1<String, Option<String>>)(Function1<String, Option> & Serializable & scala.Serializable)key -> sys$1.comments().get((String)key)));
        SMTSymbol s = SMTSymbol$.MODULE$.fromExpr(new StringBuilder(0).append(sym.name()).append(this.SignalSuffix()).toString(), sym);
        cmds$1.$plus$eq(new DeclareFunction(s, new $colon$colon<Nothing$>((Nothing$)((Object)stateType$1), Nil$.MODULE$)));
    }

    private final void define$1(SMTSymbol sym, SMTExpr e, String suffix, ArrayBuffer cmds$1, String stateType$1) {
        cmds$1.$plus$eq(new DefineFunction(new StringBuilder(0).append(sym.name()).append(suffix).toString(), new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<String, String>(this.State(), stateType$1)), Nil$.MODULE$), this.replaceSymbols(e)));
    }

    private final String define$default$3$1() {
        return this.SignalSuffix();
    }

    public static final /* synthetic */ void $anonfun$encode$4(SMTTransitionSystemEncoder$ $this, TransitionSystem sys$1, ArrayBuffer cmds$1, String stateType$1, Signal signal) {
        String kind = sys$1.outputs().contains(signal.name()) ? "output" : (sys$1.assumes().contains(signal.name()) ? "assume" : (sys$1.asserts().contains(signal.name()) ? "assert" : "wire"));
        SMTSymbol sym = SMTSymbol$.MODULE$.fromExpr(signal.name(), signal.e());
        cmds$1.$plus$plus$eq((TraversableOnce)MODULE$.toDescription(sym, kind, (Function1<String, Option<String>>)(Function1<String, Option> & Serializable & scala.Serializable)key -> sys$1.comments().get((String)key)));
        $this.define$1(sym, signal.e(), $this.define$default$3$1(), cmds$1, stateType$1);
    }

    public static final /* synthetic */ void $anonfun$encode$6(SMTTransitionSystemEncoder$ $this, ArrayBuffer cmds$1, String stateType$1, State state) {
        Predef$.MODULE$.assert(state.next().nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Next function required");
        $this.define$1(state.sym(), state.next().get(), MODULE$.NextSuffix(), cmds$1, stateType$1);
        state.init().foreach((Function1<SMTExpr, Object> & Serializable & scala.Serializable)init -> {
            $this.define$1(state.sym(), init, SMTTransitionSystemEncoder$.MODULE$.InitSuffix(), cmds$1, stateType$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void defineConjunction$1(Iterable e, String suffix, String name$1, ArrayBuffer cmds$1, String stateType$1) {
        this.define$1(new BVSymbol(name$1, 1), this.andReduce(e), suffix, cmds$1, stateType$1);
    }

    public static final /* synthetic */ boolean $anonfun$encode$10(State x$1) {
        return x$1.init().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$encode$12(TransitionSystem sys$1, Signal a) {
        return sys$1.asserts().contains(a.name());
    }

    public static final /* synthetic */ boolean $anonfun$encode$14(TransitionSystem sys$1, Signal a) {
        return sys$1.assumes().contains(a.name());
    }

    private SMTTransitionSystemEncoder$() {
        MODULE$ = this;
        this.State = "state";
        this.StateNext = "state_n";
        this.SignalSuffix = "_f";
        this.NextSuffix = "_next";
        this.InitSuffix = "_init";
    }
}

