/*
 * Decompiled with CFR 0.152.
 */
package firrtl.ir;

import firrtl.CDefMPort;
import firrtl.CDefMemory;
import firrtl.EmptyExpression$;
import firrtl.MPortDir;
import firrtl.WDefInstanceConnector;
import firrtl.WInvalid$;
import firrtl.WVoid$;
import firrtl.constraint.Constraint;
import firrtl.ir.AnalogType;
import firrtl.ir.AsyncResetType$;
import firrtl.ir.Attach;
import firrtl.ir.Block;
import firrtl.ir.BundleType;
import firrtl.ir.CalcBound;
import firrtl.ir.CalcWidth;
import firrtl.ir.Circuit;
import firrtl.ir.ClockType$;
import firrtl.ir.Closed;
import firrtl.ir.Conditionally;
import firrtl.ir.Connect;
import firrtl.ir.DefInstance;
import firrtl.ir.DefMemory;
import firrtl.ir.DefModule;
import firrtl.ir.DefNode;
import firrtl.ir.DefRegister;
import firrtl.ir.DefWire;
import firrtl.ir.Default$;
import firrtl.ir.Direction;
import firrtl.ir.DoPrim;
import firrtl.ir.DoubleParam;
import firrtl.ir.EmptyStmt$;
import firrtl.ir.Expression;
import firrtl.ir.ExtModule;
import firrtl.ir.Field;
import firrtl.ir.FileInfo;
import firrtl.ir.FirrtlNode;
import firrtl.ir.FixedLiteral;
import firrtl.ir.FixedType;
import firrtl.ir.Flip$;
import firrtl.ir.Info;
import firrtl.ir.Input$;
import firrtl.ir.IntParam;
import firrtl.ir.IntWidth;
import firrtl.ir.IntWidth$;
import firrtl.ir.IntervalType;
import firrtl.ir.IsInvalid;
import firrtl.ir.Module;
import firrtl.ir.MultiInfo;
import firrtl.ir.Mux;
import firrtl.ir.NoInfo$;
import firrtl.ir.Open;
import firrtl.ir.Orientation;
import firrtl.ir.Output$;
import firrtl.ir.Param;
import firrtl.ir.PartialConnect;
import firrtl.ir.Port;
import firrtl.ir.PrimOp;
import firrtl.ir.Print;
import firrtl.ir.RawStringParam;
import firrtl.ir.Reference;
import firrtl.ir.ResetType$;
import firrtl.ir.SIntLiteral;
import firrtl.ir.SIntType;
import firrtl.ir.Statement;
import firrtl.ir.Stop;
import firrtl.ir.StringLit;
import firrtl.ir.StringParam;
import firrtl.ir.SubAccess;
import firrtl.ir.SubField;
import firrtl.ir.SubIndex;
import firrtl.ir.Type;
import firrtl.ir.UIntLiteral;
import firrtl.ir.UIntType;
import firrtl.ir.UnknownBound$;
import firrtl.ir.UnknownType$;
import firrtl.ir.UnknownWidth$;
import firrtl.ir.ValidIf;
import firrtl.ir.VarBound;
import firrtl.ir.VarWidth;
import firrtl.ir.VectorType;
import firrtl.ir.Verification;
import firrtl.ir.Width;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class Serializer$ {
    public static Serializer$ MODULE$;
    private final char NewLine;
    private final String Indent;

    static {
        new Serializer$();
    }

    public char NewLine() {
        return this.NewLine;
    }

    public String Indent() {
        return this.Indent;
    }

    public String serialize(FirrtlNode node) {
        Serializable serializable;
        StringBuilder builder = new StringBuilder();
        int indent = 0;
        FirrtlNode firrtlNode = node;
        if (firrtlNode instanceof Info) {
            Info info = (Info)firrtlNode;
            this.s(info, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof StringLit) {
            StringLit stringLit = (StringLit)firrtlNode;
            this.s(stringLit, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Expression) {
            Expression expression = (Expression)firrtlNode;
            this.s(expression, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Statement) {
            Statement statement = (Statement)firrtlNode;
            this.s(statement, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Width) {
            Width width = (Width)firrtlNode;
            this.s(width, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Orientation) {
            Orientation orientation = (Orientation)firrtlNode;
            this.s(orientation, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Field) {
            Field field2 = (Field)firrtlNode;
            this.firrtl$ir$Serializer$$s(field2, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Type) {
            Type type = (Type)firrtlNode;
            this.s(type, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Direction) {
            Direction direction = (Direction)firrtlNode;
            this.s(direction, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Port) {
            Port port = (Port)firrtlNode;
            this.s(port, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Param) {
            Param param2 = (Param)firrtlNode;
            this.s(param2, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof DefModule) {
            DefModule defModule = (DefModule)firrtlNode;
            this.s(defModule, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Circuit) {
            Circuit circuit = (Circuit)firrtlNode;
            this.s(circuit, builder, indent);
            serializable = BoxedUnit.UNIT;
        } else {
            serializable = builder.$plus$plus$eq(firrtlNode.serialize());
        }
        return builder.toString();
    }

    public String serialize(Constraint con) {
        StringBuilder builder = new StringBuilder();
        this.s(con, builder);
        return builder.toString();
    }

    private Seq<FileInfo> flattenInfo(Seq<Info> infos) {
        return infos.flatMap((Function1<Info, Seq> & Serializable & scala.Serializable)x0$1 -> {
            Seq<FileInfo> seq;
            Info info = x0$1;
            if (NoInfo$.MODULE$.equals(info)) {
                seq = Nil$.MODULE$;
            } else if (info instanceof FileInfo) {
                FileInfo fileInfo = (FileInfo)info;
                seq = new $colon$colon<Nothing$>((Nothing$)((Object)fileInfo), Nil$.MODULE$);
            } else if (info instanceof MultiInfo) {
                MultiInfo multiInfo = (MultiInfo)info;
                Seq<Info> infos = multiInfo.infos();
                seq = MODULE$.flattenInfo(infos);
            } else {
                throw new MatchError(info);
            }
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void s(Info node, StringBuilder b, int indent) {
        Info info = node;
        if (info instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)info;
            b.$plus$plus$eq(" @[");
            b.$plus$plus$eq(fileInfo.escaped());
            b.$plus$plus$eq("]");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NoInfo$.MODULE$.equals(info)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (info instanceof MultiInfo) {
            BoxedUnit boxedUnit;
            MultiInfo multiInfo = (MultiInfo)info;
            Seq<FileInfo> infos = multiInfo.flatten();
            if (infos.nonEmpty()) {
                int lastId = infos.length() - 1;
                b.$plus$plus$eq(" @[");
                ((IterableLike)infos.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    FileInfo f = (FileInfo)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    b.$plus$plus$eq(f.escaped());
                    BoxedUnit boxedUnit = i < lastId ? b.$plus$eq(' ') : BoxedUnit.UNIT;
                    return boxedUnit;
                });
                b.$plus$eq(']');
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            b.$plus$plus$eq(info.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void s(StringLit str, StringBuilder b, int indent) {
        b.$plus$plus$eq(str.serialize());
    }

    private void s(Expression node, StringBuilder b, int indent) {
        Expression expression = node;
        if (expression instanceof Reference) {
            Reference reference = (Reference)expression;
            String name = reference.name();
            b.$plus$plus$eq(name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression instanceof DoPrim) {
            DoPrim doPrim = (DoPrim)expression;
            PrimOp op = doPrim.op();
            Seq<Expression> args = doPrim.args();
            Seq<BigInt> consts = doPrim.consts();
            b.$plus$plus$eq(op.toString());
            b.$plus$eq('(');
            this.s(args, ", ", consts.isEmpty(), b, indent);
            this.s(consts, ", ", b);
            b.$plus$eq(')');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression instanceof UIntLiteral) {
            UIntLiteral uIntLiteral = (UIntLiteral)expression;
            BigInt value = uIntLiteral.value();
            Width width = uIntLiteral.width();
            b.$plus$plus$eq("UInt");
            this.s(width, b, indent);
            b.$plus$plus$eq("(\"h");
            b.$plus$plus$eq(value.toString(16));
            b.$plus$plus$eq("\")");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression instanceof SubField) {
            SubField subField = (SubField)expression;
            Expression expr = subField.expr();
            String name = subField.name();
            this.s(expr, b, indent);
            b.$plus$eq('.');
            b.$plus$plus$eq(name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression instanceof SubIndex) {
            SubIndex subIndex = (SubIndex)expression;
            Expression expr = subIndex.expr();
            int value = subIndex.value();
            this.s(expr, b, indent);
            b.$plus$eq('[');
            b.$plus$plus$eq(Integer.toString(value));
            b.$plus$eq(']');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression instanceof SubAccess) {
            SubAccess subAccess = (SubAccess)expression;
            Expression expr = subAccess.expr();
            Expression index = subAccess.index();
            this.s(expr, b, indent);
            b.$plus$eq('[');
            this.s(index, b, indent);
            b.$plus$eq(']');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression instanceof Mux) {
            Mux mux = (Mux)expression;
            Expression cond = mux.cond();
            Expression tval = mux.tval();
            Expression fval = mux.fval();
            b.$plus$plus$eq("mux(");
            this.s(cond, b, indent);
            b.$plus$plus$eq(", ");
            this.s(tval, b, indent);
            b.$plus$plus$eq(", ");
            this.s(fval, b, indent);
            b.$plus$eq(')');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression instanceof ValidIf) {
            ValidIf validIf = (ValidIf)expression;
            Expression cond = validIf.cond();
            Expression value = validIf.value();
            b.$plus$plus$eq("validif(");
            this.s(cond, b, indent);
            b.$plus$plus$eq(", ");
            this.s(value, b, indent);
            b.$plus$eq(')');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression instanceof SIntLiteral) {
            SIntLiteral sIntLiteral = (SIntLiteral)expression;
            BigInt value = sIntLiteral.value();
            Width width = sIntLiteral.width();
            b.$plus$plus$eq("SInt");
            this.s(width, b, indent);
            b.$plus$plus$eq("(\"h");
            b.$plus$plus$eq(value.toString(16));
            b.$plus$plus$eq("\")");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression instanceof FixedLiteral) {
            FixedLiteral fixedLiteral = (FixedLiteral)expression;
            BigInt value = fixedLiteral.value();
            Width width = fixedLiteral.width();
            Width point = fixedLiteral.point();
            b.$plus$plus$eq("Fixed");
            this.s(width, b, indent);
            this.sPoint(point, b, indent);
            b.$plus$plus$eq("(\"h");
            b.$plus$plus$eq(value.toString(16));
            b.$plus$plus$eq("\")");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (WVoid$.MODULE$.equals(expression)) {
            b.$plus$plus$eq("VOID");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (WInvalid$.MODULE$.equals(expression)) {
            b.$plus$plus$eq("INVALID");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (EmptyExpression$.MODULE$.equals(expression)) {
            b.$plus$plus$eq("EMPTY");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            b.$plus$plus$eq(expression.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void s(Statement node, StringBuilder b, int indent) {
        Statement statement;
        Block block;
        boolean bl;
        block22: {
            while (true) {
                bl = false;
                block = null;
                statement = node;
                if (statement instanceof DefNode) {
                    DefNode defNode = (DefNode)statement;
                    Info info = defNode.info();
                    String name = defNode.name();
                    Expression value = defNode.value();
                    b.$plus$plus$eq("node ");
                    b.$plus$plus$eq(name);
                    b.$plus$plus$eq(" = ");
                    this.s(value, b, indent);
                    this.s(info, b, indent);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (statement instanceof Connect) {
                    Connect connect = (Connect)statement;
                    Info info = connect.info();
                    Expression loc = connect.loc();
                    Expression expr = connect.expr();
                    this.s(loc, b, indent);
                    b.$plus$plus$eq(" <= ");
                    this.s(expr, b, indent);
                    this.s(info, b, indent);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (!(statement instanceof Conditionally)) break block22;
                Conditionally conditionally = (Conditionally)statement;
                Info info = conditionally.info();
                Expression pred = conditionally.pred();
                Statement conseq = conditionally.conseq();
                Statement alt = conditionally.alt();
                b.$plus$plus$eq("when ");
                this.s(pred, b, indent);
                b.$plus$plus$eq(" :");
                this.s(info, b, indent);
                this.newLineAndIndent(1, b, indent);
                this.s(conseq, b, indent + 1);
                Statement statement2 = alt;
                EmptyStmt$ emptyStmt$ = EmptyStmt$.MODULE$;
                if (!(statement2 == null ? emptyStmt$ != null : !statement2.equals(emptyStmt$))) break;
                this.newLineAndIndent(this.newLineAndIndent$default$1(), b, indent);
                b.$plus$plus$eq("else :");
                this.newLineAndIndent(1, b, indent);
                ++indent;
                node = alt;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (EmptyStmt$.MODULE$.equals(statement)) {
            b.$plus$plus$eq("skip");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof Block) {
            bl = true;
            block = (Block)statement;
            Seq<Statement> seq = block.stmts();
            Some<Seq<Statement>> some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                b.$plus$plus$eq("skip");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            Seq<Statement> stmts = block.stmts();
            Iterator it = stmts.iterator();
            while (true) {
                if (!it.hasNext()) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                this.s((Statement)it.next(), b, indent);
                if (!it.hasNext()) continue;
                this.newLineAndIndent(this.newLineAndIndent$default$1(), b, indent);
            }
        }
        if (statement instanceof Stop) {
            Stop stop = (Stop)statement;
            Info info = stop.info();
            int ret = stop.ret();
            Expression clk = stop.clk();
            Expression en = stop.en();
            b.$plus$plus$eq("stop(");
            this.s(clk, b, indent);
            b.$plus$plus$eq(", ");
            this.s(en, b, indent);
            b.$plus$plus$eq(", ");
            b.$plus$plus$eq(Integer.toString(ret));
            b.$plus$eq(')');
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof Print) {
            Print print = (Print)statement;
            Info info = print.info();
            StringLit string = print.string();
            Seq<Expression> args = print.args();
            Expression clk = print.clk();
            Expression en = print.en();
            b.$plus$plus$eq("printf(");
            this.s(clk, b, indent);
            b.$plus$plus$eq(", ");
            this.s(en, b, indent);
            b.$plus$plus$eq(", ");
            b.$plus$plus$eq(string.escape());
            Serializable serializable = args.nonEmpty() ? b.$plus$plus$eq(", ") : BoxedUnit.UNIT;
            this.s(args, ", ", this.s$default$3(), b, indent);
            b.$plus$eq(')');
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof IsInvalid) {
            IsInvalid isInvalid = (IsInvalid)statement;
            Info info = isInvalid.info();
            Expression expr = isInvalid.expr();
            this.s(expr, b, indent);
            b.$plus$plus$eq(" is invalid");
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof DefWire) {
            DefWire defWire = (DefWire)statement;
            Info info = defWire.info();
            String name = defWire.name();
            Type tpe = defWire.tpe();
            b.$plus$plus$eq("wire ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" : ");
            this.s(tpe, b, indent);
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof DefRegister) {
            DefRegister defRegister = (DefRegister)statement;
            Info info = defRegister.info();
            String name = defRegister.name();
            Type tpe = defRegister.tpe();
            Expression clock = defRegister.clock();
            Expression reset = defRegister.reset();
            Expression init = defRegister.init();
            b.$plus$plus$eq("reg ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" : ");
            this.s(tpe, b, indent);
            b.$plus$plus$eq(", ");
            this.s(clock, b, indent);
            b.$plus$plus$eq(" with :");
            this.newLineAndIndent(1, b, indent);
            b.$plus$plus$eq("reset => (");
            this.s(reset, b, indent);
            b.$plus$plus$eq(", ");
            this.s(init, b, indent);
            b.$plus$eq(')');
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof DefInstance) {
            DefInstance defInstance = (DefInstance)statement;
            Info info = defInstance.info();
            String name = defInstance.name();
            String module = defInstance.module();
            b.$plus$plus$eq("inst ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" of ");
            b.$plus$plus$eq(module);
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof DefMemory) {
            DefMemory defMemory = (DefMemory)statement;
            Info info = defMemory.info();
            String name = defMemory.name();
            Type dataType = defMemory.dataType();
            BigInt depth = defMemory.depth();
            int writeLatency = defMemory.writeLatency();
            int readLatency = defMemory.readLatency();
            Seq<String> readers = defMemory.readers();
            Seq<String> writers = defMemory.writers();
            Seq<String> readwriters = defMemory.readwriters();
            Enumeration.Value readUnderWrite = defMemory.readUnderWrite();
            b.$plus$plus$eq("mem ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" :");
            this.s(info, b, indent);
            this.newLineAndIndent(1, b, indent);
            b.$plus$plus$eq("data-type => ");
            this.s(dataType, b, indent);
            this.newLineAndIndent(1, b, indent);
            b.$plus$plus$eq("depth => ");
            b.$plus$plus$eq(depth.toString());
            this.newLineAndIndent(1, b, indent);
            b.$plus$plus$eq("read-latency => ");
            b.$plus$plus$eq(Integer.toString(readLatency));
            this.newLineAndIndent(1, b, indent);
            b.$plus$plus$eq("write-latency => ");
            b.$plus$plus$eq(Integer.toString(writeLatency));
            this.newLineAndIndent(1, b, indent);
            readers.foreach((Function1<String, Object> & Serializable & scala.Serializable)r -> {
                Serializer$.$anonfun$s$2(b, indent, r);
                return BoxedUnit.UNIT;
            });
            writers.foreach((Function1<String, Object> & Serializable & scala.Serializable)w -> {
                Serializer$.$anonfun$s$3(b, indent, w);
                return BoxedUnit.UNIT;
            });
            readwriters.foreach((Function1<String, Object> & Serializable & scala.Serializable)r -> {
                Serializer$.$anonfun$s$4(b, indent, r);
                return BoxedUnit.UNIT;
            });
            b.$plus$plus$eq("read-under-write => ");
            b.$plus$plus$eq(readUnderWrite.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof PartialConnect) {
            PartialConnect partialConnect = (PartialConnect)statement;
            Info info = partialConnect.info();
            Expression loc = partialConnect.loc();
            Expression expr = partialConnect.expr();
            this.s(loc, b, indent);
            b.$plus$plus$eq(" <- ");
            this.s(expr, b, indent);
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof Attach) {
            Attach attach = (Attach)statement;
            Info info = attach.info();
            Seq<Expression> exprs = attach.exprs();
            b.$plus$plus$eq("attach (");
            this.s(exprs, ", ", this.s$default$3(), b, indent);
            b.$plus$eq(')');
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof Verification) {
            Verification verification = (Verification)statement;
            Enumeration.Value op = verification.op();
            Info info = verification.info();
            Expression clk = verification.clk();
            Expression pred = verification.pred();
            Expression en = verification.en();
            StringLit msg = verification.msg();
            b.$plus$plus$eq(op.toString());
            b.$plus$eq('(');
            this.s(new $colon$colon<Nothing$>((Nothing$)((Object)clk), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)pred), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)en), Nil$.MODULE$))), ", ", false, b, indent);
            b.$plus$plus$eq(msg.escape());
            b.$plus$eq(')');
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof CDefMemory) {
            CDefMemory cDefMemory = (CDefMemory)statement;
            Info info = cDefMemory.info();
            String name = cDefMemory.name();
            Type tpe = cDefMemory.tpe();
            BigInt size = cDefMemory.size();
            boolean seq = cDefMemory.seq();
            StringBuilder stringBuilder = seq ? b.$plus$plus$eq("smem ") : b.$plus$plus$eq("cmem ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" : ");
            this.s(tpe, b, indent);
            b.$plus$plus$eq(" [");
            b.$plus$plus$eq(size.toString());
            b.$plus$eq(']');
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof CDefMPort) {
            CDefMPort cDefMPort = (CDefMPort)statement;
            Info info = cDefMPort.info();
            String name = cDefMPort.name();
            String mem = cDefMPort.mem();
            Seq<Expression> exps = cDefMPort.exps();
            MPortDir direction = cDefMPort.direction();
            b.$plus$plus$eq(direction.serialize());
            b.$plus$plus$eq(" mport ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" = ");
            b.$plus$plus$eq(mem);
            b.$plus$eq('[');
            this.s((Expression)exps.head(), b, indent);
            b.$plus$plus$eq("], ");
            this.s((Expression)exps.apply(true), b, indent);
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (statement instanceof WDefInstanceConnector) {
            WDefInstanceConnector wDefInstanceConnector = (WDefInstanceConnector)statement;
            Info info = wDefInstanceConnector.info();
            String name = wDefInstanceConnector.name();
            String module = wDefInstanceConnector.module();
            Type tpe = wDefInstanceConnector.tpe();
            Seq<Tuple2<Expression, Expression>> portCons = wDefInstanceConnector.portCons();
            b.$plus$plus$eq("inst ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" of ");
            b.$plus$plus$eq(module);
            b.$plus$plus$eq(" with ");
            this.s(tpe, b, indent);
            b.$plus$plus$eq(" connected to (");
            this.s(portCons.map((Function1<Tuple2, Expression> & Serializable & scala.Serializable)x$1 -> (Expression)x$1._2(), Seq$.MODULE$.canBuildFrom()), ",  ", this.s$default$3(), b, indent);
            b.$plus$eq(')');
            this.s(info, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        b.$plus$plus$eq(statement.serialize());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void s(Width node, StringBuilder b, int indent) {
        IntWidth intWidth;
        Option<BigInt> option;
        Width width = node;
        if (width instanceof IntWidth && !(option = IntWidth$.MODULE$.unapply(intWidth = (IntWidth)width)).isEmpty()) {
            BigInt width2 = option.get();
            b.$plus$eq('<');
            b.$plus$plus$eq(width2.toString());
            b.$plus$eq('>');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (UnknownWidth$.MODULE$.equals(width)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (width instanceof CalcWidth) {
            CalcWidth calcWidth = (CalcWidth)width;
            Constraint arg = calcWidth.arg();
            b.$plus$plus$eq("calcw(");
            this.s(arg, b);
            b.$plus$eq(')');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (width instanceof VarWidth) {
            VarWidth varWidth = (VarWidth)width;
            String name = varWidth.name();
            b.$plus$eq('<');
            b.$plus$plus$eq(name);
            b.$plus$eq('>');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            b.$plus$plus$eq(width.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void sPoint(Width node, StringBuilder b, int indent) {
        IntWidth intWidth;
        Option<BigInt> option;
        Width width = node;
        if (width instanceof IntWidth && !(option = IntWidth$.MODULE$.unapply(intWidth = (IntWidth)width)).isEmpty()) {
            BigInt width2 = option.get();
            b.$plus$plus$eq("<<");
            b.$plus$plus$eq(width2.toString());
            b.$plus$plus$eq(">>");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (UnknownWidth$.MODULE$.equals(width)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (width instanceof CalcWidth) {
            CalcWidth calcWidth = (CalcWidth)width;
            Constraint arg = calcWidth.arg();
            b.$plus$plus$eq("calcw(");
            this.s(arg, b);
            b.$plus$eq(')');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (width instanceof VarWidth) {
            VarWidth varWidth = (VarWidth)width;
            String name = varWidth.name();
            b.$plus$plus$eq("<<");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(">>");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            b.$plus$plus$eq(width.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void s(Orientation node, StringBuilder b, int indent) {
        Orientation orientation = node;
        if (Default$.MODULE$.equals(orientation)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Flip$.MODULE$.equals(orientation)) {
            b.$plus$plus$eq("flip ");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            b.$plus$plus$eq(orientation.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void firrtl$ir$Serializer$$s(Field node, StringBuilder b, int indent) {
        Field field2 = node;
        if (field2 == null) {
            throw new MatchError(field2);
        }
        String name = field2.name();
        Orientation flip = field2.flip();
        Type tpe = field2.tpe();
        this.s(flip, b, indent);
        b.$plus$plus$eq(name);
        b.$plus$plus$eq(" : ");
        this.s(tpe, b, indent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void s(Type node, StringBuilder b, int indent) {
        SIntType sIntType;
        Width width;
        UIntType uIntType;
        Width width2;
        Type type = node;
        if (type instanceof UIntType && (width2 = (uIntType = (UIntType)type).width()) != null) {
            Width width3 = width2;
            b.$plus$plus$eq("UInt");
            this.s(width3, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type instanceof SIntType && (width = (sIntType = (SIntType)type).width()) != null) {
            Width width4 = width;
            b.$plus$plus$eq("SInt");
            this.s(width4, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type instanceof FixedType) {
            FixedType fixedType = (FixedType)type;
            Width width5 = fixedType.width();
            Width point = fixedType.point();
            b.$plus$plus$eq("Fixed");
            this.s(width5, b, indent);
            this.sPoint(point, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type instanceof BundleType) {
            BundleType bundleType = (BundleType)type;
            Seq<Field> fields = bundleType.fields();
            b.$plus$plus$eq("{ ");
            this.sField(fields, ", ", b, indent);
            b.$plus$eq('}');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            Type tpe = vectorType.tpe();
            int size = vectorType.size();
            this.s(tpe, b, indent);
            b.$plus$eq('[');
            b.$plus$plus$eq(Integer.toString(size));
            b.$plus$eq(']');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ClockType$.MODULE$.equals(type)) {
            b.$plus$plus$eq("Clock");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ResetType$.MODULE$.equals(type)) {
            b.$plus$plus$eq("Reset");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (AsyncResetType$.MODULE$.equals(type)) {
            b.$plus$plus$eq("AsyncReset");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type instanceof AnalogType) {
            AnalogType analogType = (AnalogType)type;
            Width width6 = analogType.width();
            b.$plus$plus$eq("Analog");
            this.s(width6, b, indent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (UnknownType$.MODULE$.equals(type)) {
            b.$plus$eq('?');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type instanceof IntervalType) {
            IntervalType intervalType = (IntervalType)type;
            b.$plus$plus$eq(intervalType.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            b.$plus$plus$eq(type.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void s(Direction node, StringBuilder b, int indent) {
        Direction direction = node;
        if (Input$.MODULE$.equals(direction)) {
            b.$plus$plus$eq("input");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Output$.MODULE$.equals(direction)) {
            b.$plus$plus$eq("output");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            b.$plus$plus$eq(direction.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void s(Port node, StringBuilder b, int indent) {
        Port port = node;
        if (port == null) {
            throw new MatchError(port);
        }
        Info info = port.info();
        String name = port.name();
        Direction direction = port.direction();
        Type tpe = port.tpe();
        this.s(direction, b, indent);
        b.$plus$eq(' ');
        b.$plus$plus$eq(name);
        b.$plus$plus$eq(" : ");
        this.s(tpe, b, indent);
        this.s(info, b, indent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void s(Param node, StringBuilder b, int indent) {
        Param param2 = node;
        if (param2 instanceof IntParam) {
            IntParam intParam = (IntParam)param2;
            String name = intParam.name();
            BigInt value = intParam.value();
            b.$plus$plus$eq("parameter ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" = ");
            b.$plus$plus$eq(value.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (param2 instanceof DoubleParam) {
            DoubleParam doubleParam = (DoubleParam)param2;
            String name = doubleParam.name();
            double value = doubleParam.value();
            b.$plus$plus$eq("parameter ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" = ");
            b.$plus$plus$eq(Double.toString(value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (param2 instanceof StringParam) {
            StringParam stringParam = (StringParam)param2;
            String name = stringParam.name();
            StringLit value = stringParam.value();
            b.$plus$plus$eq("parameter ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" = ");
            b.$plus$plus$eq(value.escape());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (param2 instanceof RawStringParam) {
            RawStringParam rawStringParam = (RawStringParam)param2;
            String name = rawStringParam.name();
            String value = rawStringParam.value();
            b.$plus$plus$eq("parameter ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" = ");
            b.$plus$eq('\'');
            b.$plus$plus$eq(value.replace("'", "\\'"));
            b.$plus$eq('\'');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            b.$plus$plus$eq(param2.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void s(DefModule node, StringBuilder b, int indent) {
        DefModule defModule = node;
        if (defModule instanceof Module) {
            Module module = (Module)defModule;
            Info info = module.info();
            String name = module.name();
            Seq<Port> ports = module.ports();
            Statement body = module.body();
            b.$plus$plus$eq("module ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" :");
            this.s(info, b, indent);
            ports.foreach((Function1<Port, Object> & Serializable & scala.Serializable)p -> {
                Serializer$.$anonfun$s$6(b, indent, p);
                return BoxedUnit.UNIT;
            });
            this.newLineNoIndent(b);
            this.newLineAndIndent(1, b, indent);
            this.s(body, b, indent + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (defModule instanceof ExtModule) {
            ExtModule extModule = (ExtModule)defModule;
            Info info = extModule.info();
            String name = extModule.name();
            Seq<Port> ports = extModule.ports();
            String defname = extModule.defname();
            Seq<Param> params = extModule.params();
            b.$plus$plus$eq("extmodule ");
            b.$plus$plus$eq(name);
            b.$plus$plus$eq(" :");
            this.s(info, b, indent);
            ports.foreach((Function1<Port, Object> & Serializable & scala.Serializable)p -> {
                Serializer$.$anonfun$s$7(b, indent, p);
                return BoxedUnit.UNIT;
            });
            this.newLineAndIndent(1, b, indent);
            b.$plus$plus$eq("defname = ");
            b.$plus$plus$eq(defname);
            params.foreach((Function1<Param, Object> & Serializable & scala.Serializable)p -> {
                Serializer$.$anonfun$s$8(b, indent, p);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            b.$plus$plus$eq(defModule.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void s(Circuit node, StringBuilder b, int indent) {
        Circuit circuit = node;
        if (circuit != null) {
            Info info = circuit.info();
            Seq<DefModule> modules = circuit.modules();
            String main = circuit.main();
            b.$plus$plus$eq("circuit ");
            b.$plus$plus$eq(main);
            b.$plus$plus$eq(" :");
            this.s(info, b, indent);
            if (modules.nonEmpty()) {
                this.newLineAndIndent(1, b, indent);
                this.s((DefModule)modules.head(), b, indent + 1);
                ((IterableLike)modules.drop(1)).foreach((Function1<DefModule, Object> & Serializable & scala.Serializable)m -> {
                    Serializer$.$anonfun$s$9(b, indent, m);
                    return BoxedUnit.UNIT;
                });
            }
        } else {
            throw new MatchError(circuit);
        }
        this.newLineNoIndent(b);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void s(Constraint constraint, StringBuilder b) {
        Constraint constraint2 = constraint;
        if (UnknownBound$.MODULE$.equals(constraint2)) {
            b.$plus$eq('?');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (constraint2 instanceof CalcBound) {
            CalcBound calcBound = (CalcBound)constraint2;
            Constraint arg = calcBound.arg();
            b.$plus$plus$eq("calcb(");
            this.s(arg, b);
            b.$plus$eq(')');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (constraint2 instanceof VarBound) {
            VarBound varBound = (VarBound)constraint2;
            String name = varBound.name();
            b.$plus$plus$eq(name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (constraint2 instanceof Open) {
            Open open = (Open)constraint2;
            BigDecimal value = open.value();
            b.$plus$plus(new StringOps(Predef$.MODULE$.augmentString("o(")), IndexedSeq$.MODULE$.canBuildFrom());
            b.$plus$plus$eq(value.toString());
            b.$plus$eq(')');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (constraint2 instanceof Closed) {
            Closed closed = (Closed)constraint2;
            BigDecimal value = closed.value();
            b.$plus$plus(new StringOps(Predef$.MODULE$.augmentString("c(")), IndexedSeq$.MODULE$.canBuildFrom());
            b.$plus$plus$eq(value.toString());
            b.$plus$eq(')');
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            b.$plus$plus$eq(constraint2.serialize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void newLineAndIndent(int inc, StringBuilder b, int indent) {
        b.$plus$eq(this.NewLine());
        this.doIndent(inc, b, indent);
    }

    private int newLineAndIndent$default$1() {
        return 0;
    }

    private void newLineNoIndent(StringBuilder b) {
        b.$plus$eq(this.NewLine());
    }

    private void doIndent(int inc, StringBuilder b, int indent) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), indent + inc).foreach((Function1<Object, StringBuilder> & Serializable & scala.Serializable)x$2 -> b.$plus$plus$eq(Serializer$.MODULE$.Indent()));
    }

    private void s(Iterable<Expression> nodes, String sep, boolean noFinalSep, StringBuilder b, int indent) {
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            this.s((Expression)it.next(), b, indent);
            Serializable serializable = !noFinalSep || it.hasNext() ? b.$plus$plus$eq(sep) : BoxedUnit.UNIT;
        }
    }

    private void sField(Iterable<Field> nodes, String sep, StringBuilder b, int indent) {
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            this.firrtl$ir$Serializer$$s((Field)it.next(), b, indent);
            Serializable serializable = it.hasNext() ? b.$plus$plus$eq(sep) : BoxedUnit.UNIT;
        }
    }

    private void s(Iterable<BigInt> consts, String sep, StringBuilder b) {
        Iterator it = consts.iterator();
        while (it.hasNext()) {
            b.$plus$plus$eq(((BigInt)it.next()).toString());
            Serializable serializable = it.hasNext() ? b.$plus$plus$eq(sep) : BoxedUnit.UNIT;
        }
    }

    private boolean s$default$3() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$s$2(StringBuilder b$2, int indent$1, String r) {
        b$2.$plus$plus$eq("reader => ");
        b$2.$plus$plus$eq(r);
        MODULE$.newLineAndIndent(1, b$2, indent$1);
    }

    public static final /* synthetic */ void $anonfun$s$3(StringBuilder b$2, int indent$1, String w) {
        b$2.$plus$plus$eq("writer => ");
        b$2.$plus$plus$eq(w);
        MODULE$.newLineAndIndent(1, b$2, indent$1);
    }

    public static final /* synthetic */ void $anonfun$s$4(StringBuilder b$2, int indent$1, String r) {
        b$2.$plus$plus$eq("readwriter => ");
        b$2.$plus$plus$eq(r);
        MODULE$.newLineAndIndent(1, b$2, indent$1);
    }

    public static final /* synthetic */ void $anonfun$s$6(StringBuilder b$3, int indent$2, Port p) {
        MODULE$.newLineAndIndent(1, b$3, indent$2);
        MODULE$.s(p, b$3, indent$2);
    }

    public static final /* synthetic */ void $anonfun$s$7(StringBuilder b$3, int indent$2, Port p) {
        MODULE$.newLineAndIndent(1, b$3, indent$2);
        MODULE$.s(p, b$3, indent$2);
    }

    public static final /* synthetic */ void $anonfun$s$8(StringBuilder b$3, int indent$2, Param p) {
        MODULE$.newLineAndIndent(1, b$3, indent$2);
        MODULE$.s(p, b$3, indent$2);
    }

    public static final /* synthetic */ void $anonfun$s$9(StringBuilder b$4, int indent$3, DefModule m) {
        MODULE$.newLineNoIndent(b$4);
        MODULE$.newLineAndIndent(1, b$4, indent$3);
        MODULE$.s(m, b$4, indent$3 + 1);
    }

    private Serializer$() {
        MODULE$ = this;
        this.NewLine = (char)10;
        this.Indent = "  ";
    }
}

