/*
 * Decompiled with CFR 0.152.
 */
package firrtl.ir;

import firrtl.PrimOps$;
import firrtl.ir.BundleType;
import firrtl.ir.Circuit;
import firrtl.ir.DefModule;
import firrtl.ir.Direction;
import firrtl.ir.Expression;
import firrtl.ir.Field;
import firrtl.ir.FirrtlNode;
import firrtl.ir.Formal$;
import firrtl.ir.HashCode;
import firrtl.ir.Hasher;
import firrtl.ir.Info;
import firrtl.ir.MDHashCode;
import firrtl.ir.MessageDigestHasher;
import firrtl.ir.Orientation;
import firrtl.ir.Param;
import firrtl.ir.Port;
import firrtl.ir.PrimOp;
import firrtl.ir.Statement;
import firrtl.ir.StringLit;
import firrtl.ir.StructuralHash;
import firrtl.ir.Type;
import firrtl.ir.VectorType;
import firrtl.ir.Width;
import java.io.Serializable;
import java.security.MessageDigest;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Ordering$Byte$;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StructuralHash$ {
    public static StructuralHash$ MODULE$;
    private final String SHA256;
    private final Map<PrimOp, Object> primOpToId;

    static {
        new StructuralHash$();
    }

    public HashCode sha256(DefModule node, Function1<String, String> moduleRename) {
        MessageDigest m = MessageDigest.getInstance(this.SHA256());
        new StructuralHash(new MessageDigestHasher(m), moduleRename).firrtl$ir$StructuralHash$$hash(node);
        return new MDHashCode(m.digest());
    }

    public HashCode sha256WithSignificantPortNames(DefModule module, Function1<String, String> moduleRename) {
        MessageDigest m = MessageDigest.getInstance(this.SHA256());
        this.hashModuleAndPortNames(module, new MessageDigestHasher(m), moduleRename);
        return new MDHashCode(m.digest());
    }

    public HashCode sha256(String str) {
        MessageDigest m = MessageDigest.getInstance(this.SHA256());
        m.update(str.getBytes());
        return new MDHashCode(m.digest());
    }

    public Function1<String, String> sha256$default$2() {
        return (Function1<String, String> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x);
    }

    public Function1<String, String> sha256WithSignificantPortNames$default$2() {
        return (Function1<String, String> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x);
    }

    public HashCode sha256Node(FirrtlNode node) {
        MessageDigest m = MessageDigest.getInstance(this.SHA256());
        this.hash(node, new MessageDigestHasher(m), (Function1<String, String> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x));
        return new MDHashCode(m.digest());
    }

    private String SHA256() {
        return this.SHA256;
    }

    private void hash(FirrtlNode node, Hasher h, Function1<String, String> rename) {
        FirrtlNode firrtlNode = node;
        if (firrtlNode instanceof Expression) {
            Expression expression = (Expression)firrtlNode;
            new StructuralHash(h, rename).firrtl$ir$StructuralHash$$hash(expression);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Statement) {
            Statement statement = (Statement)firrtlNode;
            new StructuralHash(h, rename).firrtl$ir$StructuralHash$$hash(statement);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Type) {
            Type type = (Type)firrtlNode;
            new StructuralHash(h, rename).firrtl$ir$StructuralHash$$hash(type);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Width) {
            Width width = (Width)firrtlNode;
            new StructuralHash(h, rename).firrtl$ir$StructuralHash$$hash(width);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Orientation) {
            Orientation orientation = (Orientation)firrtlNode;
            new StructuralHash(h, rename).firrtl$ir$StructuralHash$$hash(orientation);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Field) {
            Field field2 = (Field)firrtlNode;
            new StructuralHash(h, rename).firrtl$ir$StructuralHash$$hash(field2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Direction) {
            Direction direction = (Direction)firrtlNode;
            new StructuralHash(h, rename).firrtl$ir$StructuralHash$$hash(direction);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Port) {
            Port port = (Port)firrtlNode;
            new StructuralHash(h, rename).firrtl$ir$StructuralHash$$hash(port);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (firrtlNode instanceof Param) {
            Param param2 = (Param)firrtlNode;
            new StructuralHash(h, rename).firrtl$ir$StructuralHash$$hash(param2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (firrtlNode instanceof Info) {
                throw new RuntimeException("The structural hash of Info is meaningless.");
            }
            if (firrtlNode instanceof DefModule) {
                DefModule defModule = (DefModule)firrtlNode;
                new StructuralHash(h, rename).firrtl$ir$StructuralHash$$hash(defModule);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (firrtlNode instanceof Circuit) {
                Circuit circuit = (Circuit)firrtlNode;
                this.hashCircuit(circuit, h, rename);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (firrtlNode instanceof StringLit) {
                StringLit stringLit = (StringLit)firrtlNode;
                h.update(stringLit.toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(firrtlNode);
            }
        }
    }

    private void hashModuleAndPortNames(DefModule m, Hasher h, Function1<String, String> rename) {
        StructuralHash sh = new StructuralHash(h, rename);
        sh.firrtl$ir$StructuralHash$$hash(m);
        m.ports().foreach((Function1<Port, Object> & Serializable & scala.Serializable)p -> {
            StructuralHash$.$anonfun$hashModuleAndPortNames$1(h, p);
            return BoxedUnit.UNIT;
        });
    }

    private void hashPortTypeName(Type tpe, Function1<String, BoxedUnit> h) {
        block2: {
            while (true) {
                Type vt;
                Type type;
                if ((type = tpe) instanceof BundleType) {
                    BundleType bundleType = (BundleType)type;
                    Seq<Field> fields = bundleType.fields();
                    fields.foreach((Function1<Field, Object> & Serializable & scala.Serializable)f -> {
                        StructuralHash$.$anonfun$hashPortTypeName$1(h, f);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                if (!(type instanceof VectorType)) break;
                VectorType vectorType = (VectorType)type;
                tpe = vt = vectorType.tpe();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void hashCircuit(Circuit c, Hasher h, Function1<String, String> rename) {
        h.update(127);
        h.update(c.main());
        Seq mods = (Seq)c.modules().sortBy((Function1<DefModule, String> & Serializable & scala.Serializable)x$1 -> x$1.name(), Ordering$String$.MODULE$);
        mods.foreach((Function1<DefModule, Object> & Serializable & scala.Serializable)m -> {
            StructuralHash$.$anonfun$hashCircuit$2(h, rename, m);
            return BoxedUnit.UNIT;
        });
    }

    private Map<PrimOp, Object> primOpToId() {
        return this.primOpToId;
    }

    public byte firrtl$ir$StructuralHash$$primOp(PrimOp p) {
        return BoxesRunTime.unboxToByte(this.primOpToId().apply(p));
    }

    public byte firrtl$ir$StructuralHash$$verificationOp(Enumeration.Value op) {
        int n;
        Enumeration.Value value = op;
        Enumeration.Value value2 = Formal$.MODULE$.Assert();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            n = 0;
        } else {
            Enumeration.Value value4 = Formal$.MODULE$.Assume();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                n = 1;
            } else {
                Enumeration.Value value6 = Formal$.MODULE$.Cover();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null)) {
                    n = 2;
                } else {
                    throw new MatchError(value);
                }
            }
        }
        return (byte)n;
    }

    public static final /* synthetic */ void $anonfun$hashModuleAndPortNames$1(Hasher h$1, Port p) {
        h$1.update(p.name());
        MODULE$.hashPortTypeName(p.tpe(), (Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable & scala.Serializable)s -> {
            h$1.update(s);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$hashPortTypeName$1(Function1 h$2, Field f) {
        h$2.apply(f.name());
        MODULE$.hashPortTypeName(f.tpe(), h$2);
    }

    public static final /* synthetic */ void $anonfun$hashCircuit$2(Hasher h$3, Function1 rename$1, DefModule m) {
        new StructuralHash(h$3, rename$1).firrtl$ir$StructuralHash$$hash(m);
    }

    private StructuralHash$() {
        MODULE$ = this;
        this.SHA256 = "SHA-256";
        this.primOpToId = ((TraversableOnce)((TraversableLike)PrimOps$.MODULE$.builtinPrimOps().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            PrimOp op = (PrimOp)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Tuple2<PrimOp, Byte> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(op), BoxesRunTime.boxToByte((byte)(-i - 1)));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Predef$.MODULE$.assert(BoxesRunTime.unboxToByte(this.primOpToId().values().max(Ordering$Byte$.MODULE$)) == -1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "PrimOp nodes use ids -1 ... -50");
        Predef$.MODULE$.assert(BoxesRunTime.unboxToByte(this.primOpToId().values().min(Ordering$Byte$.MODULE$)) >= -50, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "PrimOp nodes use ids -1 ... -50");
    }
}

