/*
 * Decompiled with CFR 0.152.
 */
package firrtl.stage;

import firrtl.AnnotationSeq;
import firrtl.ChirrtlEmitter;
import firrtl.Emitter;
import firrtl.HighFirrtlEmitter;
import firrtl.LowFirrtlEmitter;
import firrtl.MiddleFirrtlEmitter;
import firrtl.MinimumVerilogEmitter;
import firrtl.SystemVerilogEmitter;
import firrtl.Transform;
import firrtl.VerilogEmitter;
import firrtl.annotations.Annotation;
import firrtl.features.LowerCaseNames;
import firrtl.features.UpperCaseNames;
import firrtl.options.Dependency;
import firrtl.options.HasShellOptions;
import firrtl.options.OptionsException;
import firrtl.options.OptionsException$;
import firrtl.options.ShellOption;
import firrtl.options.ShellOption$;
import firrtl.package$;
import firrtl.stage.RunFirrtlTransformAnnotation;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.Nothing$;
import scopt.OptionParser;
import scopt.Read$;

public final class RunFirrtlTransformAnnotation$
implements HasShellOptions,
scala.Serializable {
    public static RunFirrtlTransformAnnotation$ MODULE$;
    private final Seq<ShellOption<? super String>> options;

    static {
        new RunFirrtlTransformAnnotation$();
    }

    @Override
    public final void addOptions(OptionParser<AnnotationSeq> p) {
        HasShellOptions.addOptions$(this, p);
    }

    public RunFirrtlTransformAnnotation apply(Dependency<Transform> transform2) {
        return new RunFirrtlTransformAnnotation(transform2.getObject());
    }

    public RunFirrtlTransformAnnotation stringToEmitter(String a) {
        Emitter emitter;
        String string = a;
        if ("none".equals(string)) {
            emitter = new ChirrtlEmitter();
        } else if ("high".equals(string)) {
            emitter = new HighFirrtlEmitter();
        } else if ("low".equals(string)) {
            emitter = new LowFirrtlEmitter();
        } else if ("middle".equals(string)) {
            emitter = new MiddleFirrtlEmitter();
        } else if ("verilog".equals(string)) {
            emitter = new VerilogEmitter();
        } else if ("mverilog".equals(string)) {
            emitter = new MinimumVerilogEmitter();
        } else if ("sverilog".equals(string)) {
            emitter = new SystemVerilogEmitter();
        } else {
            throw new OptionsException(new StringBuilder(48).append("Unknown compiler name '").append(a).append("'! (Did you misspell it?)").toString(), OptionsException$.MODULE$.$lessinit$greater$default$2());
        }
        ChirrtlEmitter emitter2 = emitter;
        return new RunFirrtlTransformAnnotation(emitter2);
    }

    public Seq<ShellOption<? super String>> options() {
        return this.options;
    }

    public RunFirrtlTransformAnnotation apply(Transform transform2) {
        return new RunFirrtlTransformAnnotation(transform2);
    }

    public Option<Transform> unapply(RunFirrtlTransformAnnotation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Transform>(x$0.transform());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RunFirrtlTransformAnnotation$() {
        MODULE$ = this;
        HasShellOptions.$init$(this);
        String x$12 = "change-name-case";
        Function1<String, AnnotationSeq> & Serializable & scala.Serializable x$22 = (Function1<String, AnnotationSeq> & Serializable & scala.Serializable)x$2 -> {
            AnnotationSeq annotationSeq;
            String string = x$2;
            if ("lower".equals(string)) {
                annotationSeq = package$.MODULE$.seqToAnnoSeq((Seq<Annotation>)new $colon$colon<Nothing$>((Nothing$)((Object)new RunFirrtlTransformAnnotation(new LowerCaseNames())), Nil$.MODULE$));
            } else if ("upper".equals(string)) {
                annotationSeq = package$.MODULE$.seqToAnnoSeq((Seq<Annotation>)new $colon$colon<Nothing$>((Nothing$)((Object)new RunFirrtlTransformAnnotation(new UpperCaseNames())), Nil$.MODULE$));
            } else {
                throw new OptionsException(new StringBuilder(37).append("Unknown case '").append(string).append("'. Did you misspell it?").toString(), OptionsException$.MODULE$.$lessinit$greater$default$2());
            }
            return annotationSeq;
        };
        String x$3 = "Convert all FIRRTL names to a specific case";
        Some<String> x$4 = new Some<String>("<lower|upper>");
        Option<String> x$5 = ShellOption$.MODULE$.$lessinit$greater$default$4();
        this.options = new $colon$colon<Nothing$>((Nothing$)((Object)new ShellOption<Seq<String>>("custom-transforms", (Function1<Seq, AnnotationSeq> & Serializable & scala.Serializable)x$1 -> package$.MODULE$.seqToAnnoSeq(x$1.map((Function1<String, RunFirrtlTransformAnnotation> & Serializable & scala.Serializable)txName -> {
            RunFirrtlTransformAnnotation runFirrtlTransformAnnotation;
            try {
                Transform tx = (Transform)Class.forName(txName).newInstance();
                runFirrtlTransformAnnotation = new RunFirrtlTransformAnnotation(tx);
            }
            catch (ClassNotFoundException e) {
                throw new OptionsException(new StringBuilder(57).append("Unable to locate custom transform ").append((String)txName).append(" (did you misspell it?)").toString(), e);
            }
            catch (InstantiationException e) {
                throw new OptionsException(new StringBuilder(69).append("Unable to create instance of Transform ").append((String)txName).append(" (is this an anonymous class?)").toString(), e);
            }
            catch (Throwable e) {
                throw new OptionsException(new StringBuilder(39).append("Unknown error when instantiating class ").append((String)txName).toString(), e);
            }
            return runFirrtlTransformAnnotation;
        }, Seq$.MODULE$.canBuildFrom())), "Run these transforms during compilation", new Some<String>("fct"), new Some<String>("<package>.<class>"), Read$.MODULE$.seqRead(Read$.MODULE$.stringRead()))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new ShellOption<String>(x$12, x$22, x$3, x$5, x$4, Read$.MODULE$.stringRead())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new ShellOption<String>("compiler", (Function1<String, AnnotationSeq> & Serializable & scala.Serializable)a -> package$.MODULE$.seqToAnnoSeq((Seq<Annotation>)new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.stringToEmitter((String)a)), Nil$.MODULE$)), "The FIRRTL compiler to use (default: verilog)", new Some<String>("X"), new Some<String>("<none|high|middle|low|verilog|mverilog|sverilog>"), Read$.MODULE$.stringRead())), Nil$.MODULE$)));
    }
}

