/*
 * Decompiled with CFR 0.152.
 */
package firrtl.util;

import firrtl.FileUtils$;
import firrtl.transforms.BlackBoxSourceHelper$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import logger.LazyLogging;
import logger.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessLogger;
import scala.sys.process.ProcessLogger$;

public final class BackendCompilationUtilities$
implements LazyLogging {
    public static BackendCompilationUtilities$ MODULE$;
    private File TestDirectory;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BackendCompilationUtilities$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private File TestDirectory$lzycompute() {
        BackendCompilationUtilities$ backendCompilationUtilities$ = this;
        synchronized (backendCompilationUtilities$) {
            if (!this.bitmap$0) {
                this.TestDirectory = new File("test_run_dir");
                this.bitmap$0 = true;
            }
        }
        return this.TestDirectory;
    }

    public File TestDirectory() {
        return !this.bitmap$0 ? this.TestDirectory$lzycompute() : this.TestDirectory;
    }

    public String timeStamp() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        Date now = Calendar.getInstance().getTime();
        return format.format(now);
    }

    public ProcessLogger loggingProcessLogger() {
        return ProcessLogger$.MODULE$.apply((Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable & scala.Serializable)x$1 -> {
            BackendCompilationUtilities$.$anonfun$loggingProcessLogger$1(x$1);
            return BoxedUnit.UNIT;
        }, (Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable & scala.Serializable)x$2 -> {
            BackendCompilationUtilities$.$anonfun$loggingProcessLogger$3(x$2);
            return BoxedUnit.UNIT;
        });
    }

    public void copyResourceToFile(String name, File file) {
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null) {
            throw new FileNotFoundException(new StringBuilder(11).append("Resource '").append(name).append("'").toString());
        }
        FileOutputStream out = new FileOutputStream(file);
        package$.MODULE$.Iterator().continually((JFunction0$mcI$sp & scala.Serializable)() -> in.read()).takeWhile((JFunction1$mcZI$sp & scala.Serializable)x$3 -> -1 != x$3).foreach((JFunction1$mcVI$sp & scala.Serializable)x$1 -> out.write(x$1));
        out.close();
    }

    public File createTestDirectory(String testName) {
        File outer = new File(this.TestDirectory(), testName);
        outer.mkdirs();
        return Files.createTempDirectory(outer.toPath(), this.timeStamp(), new FileAttribute[0]).toFile();
    }

    public File makeHarness(Function1<String, String> template, String post, File f) {
        String prefix = (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])f.toString().split("/"))).last();
        File vf = new File(new StringBuilder(0).append(f.toString()).append(post).toString());
        FileWriter w = new FileWriter(vf);
        w.write(template.apply(prefix));
        w.close();
        return vf;
    }

    public ProcessBuilder firrtlToVerilog(String prefix, File dir) {
        return Process$.MODULE$.apply((Seq<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"firrtl"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-i"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(4).append(prefix).append(".fir").toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-o"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(2).append(prefix).append(".v").toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-X"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"verilog"), Nil$.MODULE$))))))), dir, Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public ProcessBuilder verilogToCpp(String dutFile, File dir, Seq<File> vSources, File cppHarness, boolean suppressVcd, String resourceFileName, Seq<String> extraCmdLineArgs) {
        String topModule = dutFile;
        File list_file = new File(dir, resourceFileName);
        Seq blackBoxVerilogList = list_file.exists() ? (Seq)new $colon$colon<Nothing$>((Nothing$)((Object)"-f"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)list_file.getAbsolutePath()), Nil$.MODULE$)) : (Seq)Nil$.MODULE$;
        Set blackBoxHelperFiles = list_file.exists() ? FileUtils$.MODULE$.getLines(list_file).toSet() : Predef$.MODULE$.Set().empty();
        Seq vSourcesFiltered = (Seq)vSources.filterNot((Function1<File, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean(blackBoxHelperFiles.contains(f.getCanonicalPath())));
        Seq<String> command = ((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)new $colon$colon<Nothing$>((Nothing$)((Object)"verilator"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"--cc"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(3).append(dir.getAbsolutePath()).append("/").append(dutFile).append(".v").toString()), Nil$.MODULE$)))).$plus$plus(extraCmdLineArgs, Seq$.MODULE$.canBuildFrom())).$plus$plus(blackBoxVerilogList, Seq$.MODULE$.canBuildFrom())).$plus$plus(vSourcesFiltered.flatMap((Function1<File, Seq> & Serializable & scala.Serializable)file -> new $colon$colon<Nothing$>((Nothing$)((Object)"-v"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)file.getCanonicalPath()), Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)"--assert"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-Wno-fatal"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-Wno-WIDTH"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-Wno-STMTDLY"), Nil$.MODULE$)))), Seq$.MODULE$.canBuildFrom())).$plus$plus(suppressVcd ? Nil$.MODULE$ : new $colon$colon<Nothing$>((Nothing$)((Object)"--trace"), Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-O1", "--top-module", topModule, new StringBuilder(18).append("+define+TOP_TYPE=V").append(dutFile).toString(), new StringBuilder(27).append("+define+PRINTF_COND=!").append(topModule).append(".reset").toString(), new StringBuilder(25).append("+define+STOP_COND=!").append(topModule).append(".reset").toString(), "-CFLAGS", new StringBuilder(77).append("-Wno-undefined-bool-conversion -O1 -DTOP_TYPE=V").append(dutFile).append(" -DVL_USER_FINISH -include V").append(dutFile).append(".h").toString(), "-Mdir", dir.getAbsolutePath(), "--exe", cppHarness.getAbsolutePath()})), Seq$.MODULE$.canBuildFrom());
        this.logger().info((Function0<String> & Serializable & scala.Serializable)() -> String.valueOf(command.mkString(" ")));
        return scala.sys.process.package$.MODULE$.stringSeqToProcess(command);
    }

    public boolean verilogToCpp$default$5() {
        return false;
    }

    public String verilogToCpp$default$6() {
        return BlackBoxSourceHelper$.MODULE$.defaultFileListName();
    }

    public Seq<String> verilogToCpp$default$7() {
        return Nil$.MODULE$;
    }

    public ProcessBuilder cppToExe(String prefix, File dir) {
        return scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"make"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-C"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)dir.toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-j"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-f"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(4).append("V").append(prefix).append(".mk").toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(1).append("V").append(prefix).toString()), Nil$.MODULE$))))))));
    }

    public boolean executeExpectingFailure(String prefix, File dir, String assertionMsg) {
        BooleanRef triggered = BooleanRef.create(false);
        String string = assertionMsg;
        String string2 = "";
        boolean assertionMessageSupplied = string == null ? string2 != null : !string.equals(string2);
        int e = Process$.MODULE$.apply(new StringBuilder(3).append("./V").append(prefix).toString(), dir, Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang(ProcessLogger$.MODULE$.apply((Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable & scala.Serializable)line -> {
            BackendCompilationUtilities$.$anonfun$executeExpectingFailure$1(triggered, assertionMessageSupplied, assertionMsg, line);
            return BoxedUnit.UNIT;
        }, (Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable & scala.Serializable)x$4 -> {
            BackendCompilationUtilities$.$anonfun$executeExpectingFailure$3(x$4);
            return BoxedUnit.UNIT;
        }));
        return triggered.elem || e != 0 && (e != 134 || !assertionMessageSupplied);
    }

    public String executeExpectingFailure$default$3() {
        return "";
    }

    public boolean executeExpectingSuccess(String prefix, File dir) {
        return !this.executeExpectingFailure(prefix, dir, this.executeExpectingFailure$default$3());
    }

    public boolean yosysExpectSuccess(String customTop, String referenceTop, File testDir, int timesteps) {
        return !this.yosysExpectFailure(customTop, referenceTop, testDir, timesteps);
    }

    public int yosysExpectSuccess$default$4() {
        return 1;
    }

    public boolean yosysExpectFailure(String customTop, String referenceTop, File testDir, int timesteps) {
        String scriptFileName = new StringBuilder(13).append(testDir.getAbsolutePath()).append("/yosys_script").toString();
        PrintWriter yosysScriptWriter = new PrintWriter(scriptFileName);
        yosysScriptWriter.write(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(846).append("read_verilog ").append(testDir.getAbsolutePath()).append("/").append(customTop).append(".v\n                               |prep -flatten -top ").append(customTop).append("; proc; opt; memory\n                               |design -stash custom\n                               |read_verilog ").append(testDir.getAbsolutePath()).append("/").append(referenceTop).append(".v\n                               |prep -flatten -top ").append(referenceTop).append("; proc; opt; memory\n                               |design -stash reference\n                               |design -copy-from custom -as custom ").append(customTop).append("\n                               |design -copy-from reference -as reference ").append(referenceTop).append("\n                               |equiv_make custom reference equiv\n                               |hierarchy -top equiv\n                               |prep -flatten -top equiv\n                               |clean -purge\n                               |equiv_simple -seq ").append(timesteps).append("\n                               |equiv_induct -seq ").append(timesteps).append("\n                               |equiv_status -assert\n         ").toString())).stripMargin());
        yosysScriptWriter.close();
        String resultFileName = new StringBuilder(14).append(testDir.getAbsolutePath()).append("/yosys_results").toString();
        ProcessBuilder command = scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(9).append("yosys -s ").append(scriptFileName).toString()).$hash$greater(new File(resultFileName));
        return command.$bang() != 0;
    }

    public int yosysExpectFailure$default$4() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$loggingProcessLogger$1(String x$1) {
        MODULE$.logger().info((Function0<String> & Serializable & scala.Serializable)() -> x$1);
    }

    public static final /* synthetic */ void $anonfun$loggingProcessLogger$3(String x$2) {
        MODULE$.logger().warn((Function0<String> & Serializable & scala.Serializable)() -> x$2);
    }

    public static final /* synthetic */ void $anonfun$executeExpectingFailure$1(BooleanRef triggered$1, boolean assertionMessageSupplied$1, String assertionMsg$1, String line) {
        triggered$1.elem = triggered$1.elem || assertionMessageSupplied$1 && line.contains(assertionMsg$1);
        MODULE$.logger().info((Function0<String> & Serializable & scala.Serializable)() -> line);
    }

    public static final /* synthetic */ void $anonfun$executeExpectingFailure$3(String x$4) {
        MODULE$.logger().warn((Function0<String> & Serializable & scala.Serializable)() -> x$4);
    }

    private BackendCompilationUtilities$() {
        MODULE$ = this;
        LazyLogging.$init$(this);
    }
}

