#include"typedef.h"
/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: modp_mat.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

/**************************************************************************\
@---------------------------------------------------------------------------
@ void modp_mat(M, p)
@ matrix_TYP *M;
@ int p;
@
@ reduces the entries of M modulo p such -|p/2| < x < |p/2|
@ for every entry x of M.
@ if p = 2 or p = -2, the entries are 0 or 1.
@---------------------------------------------------------------------------
@
\**************************************************************************/

void 
modp_mat (matrix_TYP *M, int prime)
{
  int i,j, phalbe, mphalbe;

  if(prime < 0)
    prime = -prime;
  phalbe = prime/2;
  mphalbe = -phalbe;
  if(prime == 2)
    mphalbe = 0;
  for(i=0;i<M->rows;i++)
    for(j=0;j<M->cols;j++)
    {
       M->array.SZ[i][j] %=prime;
       if(M->array.SZ[i][j] < mphalbe)
         M->array.SZ[i][j] +=prime;
       if(M->array.SZ[i][j] > phalbe)
         M->array.SZ[i][j] -=prime;
    }
}
