# RepnDecomp, chapter 3
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST( "repndecomp03.tst");

# doc/_Chunks.xml:149-175
gap> G := SymmetricGroup(3);;
gap> irreps := IrreducibleRepresentations(G);;
gap> # It happens that we are given unitary irreps, so
> # rho is also unitary (its blocks are unitary)
> rho := DirectSumOfRepresentations([irreps[1], irreps[2]]);;
gap> IsUnitaryRepresentation(rho);
true
gap> # Arbitrary change of basis
> A := [ [ -1, 1 ], [ -2, -1 ] ];;
gap> tau := ComposeHomFunction(rho, x -> A^-1 * x * A);;
gap> # Not unitary, but still isomorphic to rho
> IsUnitaryRepresentation(tau);
false
gap> AreRepsIsomorphic(rho, tau);
true
gap> # Now we unitarise tau
> tau_u := UnitaryRepresentation(tau);;
gap> # We get a record with the unitarised rep:
> AreRepsIsomorphic(tau, tau_u.unitary_rep);
true
gap> AreRepsIsomorphic(rho, tau_u.unitary_rep);
true
gap> # The basis change is also in the record:
> ForAll(G, g -> tau_u.basis_change * Image(tau_u.unitary_rep, g) = Image(tau, g) * tau_u.basis_change);
true

# doc/_Chunks.xml:181-183
gap> # TODO: this example

# doc/_Chunks.xml:189-191
gap> # TODO: this example

#
gap> STOP_TEST("repndecomp03.tst", 1 );
