# ToricVarieties, single 5
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST( "toricvarieties05.tst");

# doc/_Chunks.xml:182-205
gap> rays := [ [1,0,0], [0,1,0], [0,0,1], [-1,-1,-1] ];
[ [1,0,0], [0,1,0], [0,0,1], [-1,-1,-1] ]
gap> max_cones := [ [1,2,3], [1,2,4], [1,3,4], [2,3,4] ];
[ [1,2,3], [1,2,4], [1,3,4], [2,3,4] ]
gap> fan := Fan( rays, max_cones );
<A fan in |R^3>
gap> P3 := ToricVariety( rays, max_cones, [[1],[1],[1],[1]], "x1,x2,x3,x4" );
<A toric variety of dimension 3>
gap> B1P3 := BlowupOfToricVariety( P3, "x1,x2,x3", "u0" );
<A toric variety of dimension 3>
gap> [ IsComplete( B1P3 ), IsOrbifold( B1P3 ), IsSmooth( B1P3 ) ];
[ true, true, true ]
gap> B2P3 := BlowupOfToricVariety( B1P3, "x1,u0", "u1" );
<A toric variety of dimension 3>
gap> Rank( ClassGroup( B2C3 ) );
3
gap> B3P3 := BlowupOfToricVariety( B2P3, "x1,u1", "u2" );
<A toric variety of dimension 3>
gap> CoxRing( B3P3 );
Q[x4,x3,x2,x1,u0,u1,u2]
(weights: [ ( 1, 0, 0, 0 ), ( 1, 1, 0, 0 ), ( 1, 1, 0, 0 ), 
( 1, 1, 1, 1 ), ( 0, -1, 1, 0 ), ( 0, 0, -1, 1 ), ( 0, 0, 0, -1 ) ])

#
gap> STOP_TEST("toricvarieties05.tst", 1 );
