// Code generated by "./generator ./com.deepin.daemon.accounts"; DO NOT EDIT.

package accounts

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"pkg.deepin.io/lib/dbusutil"
	"pkg.deepin.io/lib/dbusutil/proxy"
)

type Accounts interface {
	accounts // interface com.deepin.daemon.Accounts
	proxy.Object
}

type objectAccounts struct {
	interfaceAccounts // interface com.deepin.daemon.Accounts
	proxy.ImplObject
}

func NewAccounts(conn *dbus.Conn) Accounts {
	obj := new(objectAccounts)
	obj.ImplObject.Init_(conn, "com.deepin.daemon.Accounts", "/com/deepin/daemon/Accounts")
	return obj
}

type accounts interface {
	GoAllowGuestAccount(flags dbus.Flags, ch chan *dbus.Call, allow bool) *dbus.Call
	AllowGuestAccount(flags dbus.Flags, allow bool) error
	GoCreateGuestAccount(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CreateGuestAccount(flags dbus.Flags) (string, error)
	GoCreateUser(flags dbus.Flags, ch chan *dbus.Call, name string, fullName string, type0 int32) *dbus.Call
	CreateUser(flags dbus.Flags, name string, fullName string, type0 int32) (dbus.ObjectPath, error)
	GoDeleteUser(flags dbus.Flags, ch chan *dbus.Call, name string, rmFiles bool) *dbus.Call
	DeleteUser(flags dbus.Flags, name string, rmFiles bool) error
	GoFindUserById(flags dbus.Flags, ch chan *dbus.Call, uid string) *dbus.Call
	FindUserById(flags dbus.Flags, uid string) (string, error)
	GoFindUserByName(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	FindUserByName(flags dbus.Flags, name string) (string, error)
	GoIsPasswordValid(flags dbus.Flags, ch chan *dbus.Call, password string) *dbus.Call
	IsPasswordValid(flags dbus.Flags, password string) (bool, string, int32, error)
	GoIsUsernameValid(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	IsUsernameValid(flags dbus.Flags, name string) (bool, string, int32, error)
	GoRandUserIcon(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	RandUserIcon(flags dbus.Flags) (string, error)
	ConnectUserAdded(cb func(objPath string)) (dbusutil.SignalHandlerId, error)
	ConnectUserDeleted(cb func(objPath string)) (dbusutil.SignalHandlerId, error)
	UserList() proxy.PropStringArray
	GuestIcon() proxy.PropString
	AllowGuest() proxy.PropBool
}

type interfaceAccounts struct{}

func (v *interfaceAccounts) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceAccounts) GetInterfaceName_() string {
	return "com.deepin.daemon.Accounts"
}

// method AllowGuestAccount

func (v *interfaceAccounts) GoAllowGuestAccount(flags dbus.Flags, ch chan *dbus.Call, allow bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AllowGuestAccount", flags, ch, allow)
}

func (v *interfaceAccounts) AllowGuestAccount(flags dbus.Flags, allow bool) error {
	return (<-v.GoAllowGuestAccount(flags, make(chan *dbus.Call, 1), allow).Done).Err
}

// method CreateGuestAccount

func (v *interfaceAccounts) GoCreateGuestAccount(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CreateGuestAccount", flags, ch)
}

func (*interfaceAccounts) StoreCreateGuestAccount(call *dbus.Call) (user string, err error) {
	err = call.Store(&user)
	return
}

func (v *interfaceAccounts) CreateGuestAccount(flags dbus.Flags) (string, error) {
	return v.StoreCreateGuestAccount(
		<-v.GoCreateGuestAccount(flags, make(chan *dbus.Call, 1)).Done)
}

// method CreateUser

func (v *interfaceAccounts) GoCreateUser(flags dbus.Flags, ch chan *dbus.Call, name string, fullName string, type0 int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CreateUser", flags, ch, name, fullName, type0)
}

func (*interfaceAccounts) StoreCreateUser(call *dbus.Call) (user dbus.ObjectPath, err error) {
	err = call.Store(&user)
	return
}

func (v *interfaceAccounts) CreateUser(flags dbus.Flags, name string, fullName string, type0 int32) (dbus.ObjectPath, error) {
	return v.StoreCreateUser(
		<-v.GoCreateUser(flags, make(chan *dbus.Call, 1), name, fullName, type0).Done)
}

// method DeleteUser

func (v *interfaceAccounts) GoDeleteUser(flags dbus.Flags, ch chan *dbus.Call, name string, rmFiles bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeleteUser", flags, ch, name, rmFiles)
}

func (v *interfaceAccounts) DeleteUser(flags dbus.Flags, name string, rmFiles bool) error {
	return (<-v.GoDeleteUser(flags, make(chan *dbus.Call, 1), name, rmFiles).Done).Err
}

// method FindUserById

func (v *interfaceAccounts) GoFindUserById(flags dbus.Flags, ch chan *dbus.Call, uid string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".FindUserById", flags, ch, uid)
}

func (*interfaceAccounts) StoreFindUserById(call *dbus.Call) (user string, err error) {
	err = call.Store(&user)
	return
}

func (v *interfaceAccounts) FindUserById(flags dbus.Flags, uid string) (string, error) {
	return v.StoreFindUserById(
		<-v.GoFindUserById(flags, make(chan *dbus.Call, 1), uid).Done)
}

// method FindUserByName

func (v *interfaceAccounts) GoFindUserByName(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".FindUserByName", flags, ch, name)
}

func (*interfaceAccounts) StoreFindUserByName(call *dbus.Call) (user string, err error) {
	err = call.Store(&user)
	return
}

func (v *interfaceAccounts) FindUserByName(flags dbus.Flags, name string) (string, error) {
	return v.StoreFindUserByName(
		<-v.GoFindUserByName(flags, make(chan *dbus.Call, 1), name).Done)
}

// method IsPasswordValid

func (v *interfaceAccounts) GoIsPasswordValid(flags dbus.Flags, ch chan *dbus.Call, password string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsPasswordValid", flags, ch, password)
}

func (*interfaceAccounts) StoreIsPasswordValid(call *dbus.Call) (ok bool, errReason string, errCode int32, err error) {
	err = call.Store(&ok, &errReason, &errCode)
	return
}

func (v *interfaceAccounts) IsPasswordValid(flags dbus.Flags, password string) (bool, string, int32, error) {
	return v.StoreIsPasswordValid(
		<-v.GoIsPasswordValid(flags, make(chan *dbus.Call, 1), password).Done)
}

// method IsUsernameValid

func (v *interfaceAccounts) GoIsUsernameValid(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".IsUsernameValid", flags, ch, name)
}

func (*interfaceAccounts) StoreIsUsernameValid(call *dbus.Call) (ok bool, errReason string, errCode int32, err error) {
	err = call.Store(&ok, &errReason, &errCode)
	return
}

func (v *interfaceAccounts) IsUsernameValid(flags dbus.Flags, name string) (bool, string, int32, error) {
	return v.StoreIsUsernameValid(
		<-v.GoIsUsernameValid(flags, make(chan *dbus.Call, 1), name).Done)
}

// method RandUserIcon

func (v *interfaceAccounts) GoRandUserIcon(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RandUserIcon", flags, ch)
}

func (*interfaceAccounts) StoreRandUserIcon(call *dbus.Call) (iconFile string, err error) {
	err = call.Store(&iconFile)
	return
}

func (v *interfaceAccounts) RandUserIcon(flags dbus.Flags) (string, error) {
	return v.StoreRandUserIcon(
		<-v.GoRandUserIcon(flags, make(chan *dbus.Call, 1)).Done)
}

// signal UserAdded

func (v *interfaceAccounts) ConnectUserAdded(cb func(objPath string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "UserAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".UserAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var objPath string
		err := dbus.Store(sig.Body, &objPath)
		if err == nil {
			cb(objPath)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal UserDeleted

func (v *interfaceAccounts) ConnectUserDeleted(cb func(objPath string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "UserDeleted", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".UserDeleted",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var objPath string
		err := dbus.Store(sig.Body, &objPath)
		if err == nil {
			cb(objPath)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property UserList as

func (v *interfaceAccounts) UserList() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "UserList",
	}
}

// property GuestIcon s

func (v *interfaceAccounts) GuestIcon() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "GuestIcon",
	}
}

// property AllowGuest b

func (v *interfaceAccounts) AllowGuest() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "AllowGuest",
	}
}

type User interface {
	user // interface com.deepin.daemon.Accounts.User
	proxy.Object
}

type objectUser struct {
	interfaceUser // interface com.deepin.daemon.Accounts.User
	proxy.ImplObject
}

func NewUser(conn *dbus.Conn, path dbus.ObjectPath) (User, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectUser)
	obj.ImplObject.Init_(conn, "com.deepin.daemon.Accounts", path)
	return obj, nil
}

type user interface {
	GoAddGroup(flags dbus.Flags, ch chan *dbus.Call, group string) *dbus.Call
	AddGroup(flags dbus.Flags, group string) error
	GoDeleteGroup(flags dbus.Flags, ch chan *dbus.Call, group string) *dbus.Call
	DeleteGroup(flags dbus.Flags, group string) error
	GoDeleteIconFile(flags dbus.Flags, ch chan *dbus.Call, iconFile string) *dbus.Call
	DeleteIconFile(flags dbus.Flags, iconFile string) error
	GoEnableNoPasswdLogin(flags dbus.Flags, ch chan *dbus.Call, enabled bool) *dbus.Call
	EnableNoPasswdLogin(flags dbus.Flags, enabled bool) error
	GoSetAutomaticLogin(flags dbus.Flags, ch chan *dbus.Call, enabled bool) *dbus.Call
	SetAutomaticLogin(flags dbus.Flags, enabled bool) error
	GoSetDesktopBackgrounds(flags dbus.Flags, ch chan *dbus.Call, backgrounds []string) *dbus.Call
	SetDesktopBackgrounds(flags dbus.Flags, backgrounds []string) error
	GoSetFullName(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call
	SetFullName(flags dbus.Flags, name string) error
	GoSetGreeterBackground(flags dbus.Flags, ch chan *dbus.Call, background string) *dbus.Call
	SetGreeterBackground(flags dbus.Flags, background string) error
	GoSetCurrentWorkspace(flags dbus.Flags, ch chan *dbus.Call, currentWorkspace int32) *dbus.Call
	SetCurrentWorkspace(flags dbus.Flags, currentWorkspace int32) error
	GoSetHistoryLayout(flags dbus.Flags, ch chan *dbus.Call, layouts []string) *dbus.Call
	SetHistoryLayout(flags dbus.Flags, layouts []string) error
	GoSetHomeDir(flags dbus.Flags, ch chan *dbus.Call, home string) *dbus.Call
	SetHomeDir(flags dbus.Flags, home string) error
	GoSetIconFile(flags dbus.Flags, ch chan *dbus.Call, iconFile string) *dbus.Call
	SetIconFile(flags dbus.Flags, iconFile string) error
	GoSetLayout(flags dbus.Flags, ch chan *dbus.Call, layout string) *dbus.Call
	SetLayout(flags dbus.Flags, layout string) error
	GoSetLocale(flags dbus.Flags, ch chan *dbus.Call, locale string) *dbus.Call
	SetLocale(flags dbus.Flags, locale string) error
	GoSetLocked(flags dbus.Flags, ch chan *dbus.Call, locked bool) *dbus.Call
	SetLocked(flags dbus.Flags, locked bool) error
	GoSetPassword(flags dbus.Flags, ch chan *dbus.Call, password string) *dbus.Call
	SetPassword(flags dbus.Flags, password string) error
	GoSetShell(flags dbus.Flags, ch chan *dbus.Call, shell string) *dbus.Call
	SetShell(flags dbus.Flags, shell string) error
	GoSetUse24HourFormat(flags dbus.Flags, ch chan *dbus.Call, value bool) *dbus.Call
	SetUse24HourFormat(flags dbus.Flags, value bool) error
	GoSetWeekdayFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call
	SetWeekdayFormat(flags dbus.Flags, value int32) error
	GoSetShortDateFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call
	SetShortDateFormat(flags dbus.Flags, value int32) error
	GoSetLongDateFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call
	SetLongDateFormat(flags dbus.Flags, value int32) error
	GoSetShortTimeFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call
	SetShortTimeFormat(flags dbus.Flags, value int32) error
	GoSetLongTimeFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call
	SetLongTimeFormat(flags dbus.Flags, value int32) error
	GoSetWeekBegins(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call
	SetWeekBegins(flags dbus.Flags, value int32) error
	HistoryLayout() proxy.PropStringArray
	Gid() proxy.PropString
	Groups() proxy.PropStringArray
	XSession() proxy.PropString
	PasswordStatus() proxy.PropString
	LoginTime() proxy.PropUint64
	GreeterBackground() proxy.PropString
	CreatedTime() proxy.PropUint64
	UserName() proxy.PropString
	Shell() proxy.PropString
	Layout() proxy.PropString
	IconFile() proxy.PropString
	Use24HourFormat() proxy.PropBool
	AccountType() proxy.PropInt32
	HomeDir() proxy.PropString
	Locale() proxy.PropString
	DesktopBackgrounds() proxy.PropStringArray
	Locked() proxy.PropBool
	NoPasswdLogin() proxy.PropBool
	IconList() proxy.PropStringArray
	UUID() proxy.PropString
	FullName() proxy.PropString
	Uid() proxy.PropString
	AutomaticLogin() proxy.PropBool
	SystemAccount() proxy.PropBool
	WeekdayFormat() proxy.PropInt32
	ShortDateFormat() proxy.PropInt32
	LongDateFormat() proxy.PropInt32
	ShortTimeFormat() proxy.PropInt32
	LongTimeFormat() proxy.PropInt32
	WeekBegins() proxy.PropInt32
}

type interfaceUser struct{}

func (v *interfaceUser) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceUser) GetInterfaceName_() string {
	return "com.deepin.daemon.Accounts.User"
}

// method AddGroup

func (v *interfaceUser) GoAddGroup(flags dbus.Flags, ch chan *dbus.Call, group string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AddGroup", flags, ch, group)
}

func (v *interfaceUser) AddGroup(flags dbus.Flags, group string) error {
	return (<-v.GoAddGroup(flags, make(chan *dbus.Call, 1), group).Done).Err
}

// method DeleteGroup

func (v *interfaceUser) GoDeleteGroup(flags dbus.Flags, ch chan *dbus.Call, group string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeleteGroup", flags, ch, group)
}

func (v *interfaceUser) DeleteGroup(flags dbus.Flags, group string) error {
	return (<-v.GoDeleteGroup(flags, make(chan *dbus.Call, 1), group).Done).Err
}

// method DeleteIconFile

func (v *interfaceUser) GoDeleteIconFile(flags dbus.Flags, ch chan *dbus.Call, iconFile string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DeleteIconFile", flags, ch, iconFile)
}

func (v *interfaceUser) DeleteIconFile(flags dbus.Flags, iconFile string) error {
	return (<-v.GoDeleteIconFile(flags, make(chan *dbus.Call, 1), iconFile).Done).Err
}

// method EnableNoPasswdLogin

func (v *interfaceUser) GoEnableNoPasswdLogin(flags dbus.Flags, ch chan *dbus.Call, enabled bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".EnableNoPasswdLogin", flags, ch, enabled)
}

func (v *interfaceUser) EnableNoPasswdLogin(flags dbus.Flags, enabled bool) error {
	return (<-v.GoEnableNoPasswdLogin(flags, make(chan *dbus.Call, 1), enabled).Done).Err
}

// method SetAutomaticLogin

func (v *interfaceUser) GoSetAutomaticLogin(flags dbus.Flags, ch chan *dbus.Call, enabled bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetAutomaticLogin", flags, ch, enabled)
}

func (v *interfaceUser) SetAutomaticLogin(flags dbus.Flags, enabled bool) error {
	return (<-v.GoSetAutomaticLogin(flags, make(chan *dbus.Call, 1), enabled).Done).Err
}

// method SetDesktopBackgrounds

func (v *interfaceUser) GoSetDesktopBackgrounds(flags dbus.Flags, ch chan *dbus.Call, backgrounds []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetDesktopBackgrounds", flags, ch, backgrounds)
}

func (v *interfaceUser) SetDesktopBackgrounds(flags dbus.Flags, backgrounds []string) error {
	return (<-v.GoSetDesktopBackgrounds(flags, make(chan *dbus.Call, 1), backgrounds).Done).Err
}

// method SetFullName

func (v *interfaceUser) GoSetFullName(flags dbus.Flags, ch chan *dbus.Call, name string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetFullName", flags, ch, name)
}

func (v *interfaceUser) SetFullName(flags dbus.Flags, name string) error {
	return (<-v.GoSetFullName(flags, make(chan *dbus.Call, 1), name).Done).Err
}

// method SetGreeterBackground

func (v *interfaceUser) GoSetGreeterBackground(flags dbus.Flags, ch chan *dbus.Call, background string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetGreeterBackground", flags, ch, background)
}

func (v *interfaceUser) SetGreeterBackground(flags dbus.Flags, background string) error {
	return (<-v.GoSetGreeterBackground(flags, make(chan *dbus.Call, 1), background).Done).Err
}

// method SetCurrentWorkspace

func (v *interfaceUser) GoSetCurrentWorkspace(flags dbus.Flags, ch chan *dbus.Call, currentWorkspace int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetCurrentWorkspace", flags, ch, currentWorkspace)
}

func (v *interfaceUser) SetCurrentWorkspace(flags dbus.Flags, currentWorkspace int32) error {
	return (<-v.GoSetCurrentWorkspace(flags, make(chan *dbus.Call, 1), currentWorkspace).Done).Err
}

// method SetHistoryLayout

func (v *interfaceUser) GoSetHistoryLayout(flags dbus.Flags, ch chan *dbus.Call, layouts []string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetHistoryLayout", flags, ch, layouts)
}

func (v *interfaceUser) SetHistoryLayout(flags dbus.Flags, layouts []string) error {
	return (<-v.GoSetHistoryLayout(flags, make(chan *dbus.Call, 1), layouts).Done).Err
}

// method SetHomeDir

func (v *interfaceUser) GoSetHomeDir(flags dbus.Flags, ch chan *dbus.Call, home string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetHomeDir", flags, ch, home)
}

func (v *interfaceUser) SetHomeDir(flags dbus.Flags, home string) error {
	return (<-v.GoSetHomeDir(flags, make(chan *dbus.Call, 1), home).Done).Err
}

// method SetIconFile

func (v *interfaceUser) GoSetIconFile(flags dbus.Flags, ch chan *dbus.Call, iconFile string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetIconFile", flags, ch, iconFile)
}

func (v *interfaceUser) SetIconFile(flags dbus.Flags, iconFile string) error {
	return (<-v.GoSetIconFile(flags, make(chan *dbus.Call, 1), iconFile).Done).Err
}

// method SetLayout

func (v *interfaceUser) GoSetLayout(flags dbus.Flags, ch chan *dbus.Call, layout string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetLayout", flags, ch, layout)
}

func (v *interfaceUser) SetLayout(flags dbus.Flags, layout string) error {
	return (<-v.GoSetLayout(flags, make(chan *dbus.Call, 1), layout).Done).Err
}

// method SetLocale

func (v *interfaceUser) GoSetLocale(flags dbus.Flags, ch chan *dbus.Call, locale string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetLocale", flags, ch, locale)
}

func (v *interfaceUser) SetLocale(flags dbus.Flags, locale string) error {
	return (<-v.GoSetLocale(flags, make(chan *dbus.Call, 1), locale).Done).Err
}

// method SetLocked

func (v *interfaceUser) GoSetLocked(flags dbus.Flags, ch chan *dbus.Call, locked bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetLocked", flags, ch, locked)
}

func (v *interfaceUser) SetLocked(flags dbus.Flags, locked bool) error {
	return (<-v.GoSetLocked(flags, make(chan *dbus.Call, 1), locked).Done).Err
}

// method SetPassword

func (v *interfaceUser) GoSetPassword(flags dbus.Flags, ch chan *dbus.Call, password string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetPassword", flags, ch, password)
}

func (v *interfaceUser) SetPassword(flags dbus.Flags, password string) error {
	return (<-v.GoSetPassword(flags, make(chan *dbus.Call, 1), password).Done).Err
}

// method SetShell

func (v *interfaceUser) GoSetShell(flags dbus.Flags, ch chan *dbus.Call, shell string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetShell", flags, ch, shell)
}

func (v *interfaceUser) SetShell(flags dbus.Flags, shell string) error {
	return (<-v.GoSetShell(flags, make(chan *dbus.Call, 1), shell).Done).Err
}

// method SetUse24HourFormat

func (v *interfaceUser) GoSetUse24HourFormat(flags dbus.Flags, ch chan *dbus.Call, value bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetUse24HourFormat", flags, ch, value)
}

func (v *interfaceUser) SetUse24HourFormat(flags dbus.Flags, value bool) error {
	return (<-v.GoSetUse24HourFormat(flags, make(chan *dbus.Call, 1), value).Done).Err
}

// method SetWeekdayFormat

func (v *interfaceUser) GoSetWeekdayFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetWeekdayFormat", flags, ch, value)
}

func (v *interfaceUser) SetWeekdayFormat(flags dbus.Flags, value int32) error {
	return (<-v.GoSetWeekdayFormat(flags, make(chan *dbus.Call, 1), value).Done).Err
}

// method SetShortDateFormat

func (v *interfaceUser) GoSetShortDateFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetShortDateFormat", flags, ch, value)
}

func (v *interfaceUser) SetShortDateFormat(flags dbus.Flags, value int32) error {
	return (<-v.GoSetShortDateFormat(flags, make(chan *dbus.Call, 1), value).Done).Err
}

// method SetLongDateFormat

func (v *interfaceUser) GoSetLongDateFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetLongDateFormat", flags, ch, value)
}

func (v *interfaceUser) SetLongDateFormat(flags dbus.Flags, value int32) error {
	return (<-v.GoSetLongDateFormat(flags, make(chan *dbus.Call, 1), value).Done).Err
}

// method SetShortTimeFormat

func (v *interfaceUser) GoSetShortTimeFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetShortTimeFormat", flags, ch, value)
}

func (v *interfaceUser) SetShortTimeFormat(flags dbus.Flags, value int32) error {
	return (<-v.GoSetShortTimeFormat(flags, make(chan *dbus.Call, 1), value).Done).Err
}

// method SetLongTimeFormat

func (v *interfaceUser) GoSetLongTimeFormat(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetLongTimeFormat", flags, ch, value)
}

func (v *interfaceUser) SetLongTimeFormat(flags dbus.Flags, value int32) error {
	return (<-v.GoSetLongTimeFormat(flags, make(chan *dbus.Call, 1), value).Done).Err
}

// method SetWeekBegins

func (v *interfaceUser) GoSetWeekBegins(flags dbus.Flags, ch chan *dbus.Call, value int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetWeekBegins", flags, ch, value)
}

func (v *interfaceUser) SetWeekBegins(flags dbus.Flags, value int32) error {
	return (<-v.GoSetWeekBegins(flags, make(chan *dbus.Call, 1), value).Done).Err
}

// property HistoryLayout as

func (v *interfaceUser) HistoryLayout() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "HistoryLayout",
	}
}

// property Gid s

func (v *interfaceUser) Gid() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Gid",
	}
}

// property Groups as

func (v *interfaceUser) Groups() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "Groups",
	}
}

// property XSession s

func (v *interfaceUser) XSession() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "XSession",
	}
}

// property PasswordStatus s

func (v *interfaceUser) PasswordStatus() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "PasswordStatus",
	}
}

// property LoginTime t

func (v *interfaceUser) LoginTime() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "LoginTime",
	}
}

// property GreeterBackground s

func (v *interfaceUser) GreeterBackground() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "GreeterBackground",
	}
}

// property CreatedTime t

func (v *interfaceUser) CreatedTime() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "CreatedTime",
	}
}

// property UserName s

func (v *interfaceUser) UserName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "UserName",
	}
}

// property Shell s

func (v *interfaceUser) Shell() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Shell",
	}
}

// property Layout s

func (v *interfaceUser) Layout() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Layout",
	}
}

// property IconFile s

func (v *interfaceUser) IconFile() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IconFile",
	}
}

// property Use24HourFormat b

func (v *interfaceUser) Use24HourFormat() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Use24HourFormat",
	}
}

// property AccountType i

func (v *interfaceUser) AccountType() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "AccountType",
	}
}

// property HomeDir s

func (v *interfaceUser) HomeDir() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HomeDir",
	}
}

// property Locale s

func (v *interfaceUser) Locale() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Locale",
	}
}

// property DesktopBackgrounds as

func (v *interfaceUser) DesktopBackgrounds() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "DesktopBackgrounds",
	}
}

// property Locked b

func (v *interfaceUser) Locked() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Locked",
	}
}

// property NoPasswdLogin b

func (v *interfaceUser) NoPasswdLogin() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "NoPasswdLogin",
	}
}

// property IconList as

func (v *interfaceUser) IconList() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "IconList",
	}
}

// property UUID s

func (v *interfaceUser) UUID() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "UUID",
	}
}

// property FullName s

func (v *interfaceUser) FullName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FullName",
	}
}

// property Uid s

func (v *interfaceUser) Uid() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Uid",
	}
}

// property AutomaticLogin b

func (v *interfaceUser) AutomaticLogin() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "AutomaticLogin",
	}
}

// property SystemAccount b

func (v *interfaceUser) SystemAccount() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SystemAccount",
	}
}

// property WeekdayFormat i

func (v *interfaceUser) WeekdayFormat() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "WeekdayFormat",
	}
}

// property ShortDateFormat i

func (v *interfaceUser) ShortDateFormat() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "ShortDateFormat",
	}
}

// property LongDateFormat i

func (v *interfaceUser) LongDateFormat() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "LongDateFormat",
	}
}

// property ShortTimeFormat i

func (v *interfaceUser) ShortTimeFormat() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "ShortTimeFormat",
	}
}

// property LongTimeFormat i

func (v *interfaceUser) LongTimeFormat() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "LongTimeFormat",
	}
}

// property WeekBegins i

func (v *interfaceUser) WeekBegins() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "WeekBegins",
	}
}

type ImageBlur interface {
	imageBlur // interface com.deepin.daemon.ImageBlur
	proxy.Object
}

type objectImageBlur struct {
	interfaceImageBlur // interface com.deepin.daemon.ImageBlur
	proxy.ImplObject
}

func NewImageBlur(conn *dbus.Conn) ImageBlur {
	obj := new(objectImageBlur)
	obj.ImplObject.Init_(conn, "com.deepin.daemon.Accounts", "/com/deepin/daemon/ImageBlur")
	return obj
}

type imageBlur interface {
	GoDelete(flags dbus.Flags, ch chan *dbus.Call, file string) *dbus.Call
	Delete(flags dbus.Flags, file string) error
	GoGet(flags dbus.Flags, ch chan *dbus.Call, source string) *dbus.Call
	Get(flags dbus.Flags, source string) (string, error)
	ConnectBlurDone(cb func(imgFile string, imgBlurFile string, ok bool)) (dbusutil.SignalHandlerId, error)
}

type interfaceImageBlur struct{}

func (v *interfaceImageBlur) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceImageBlur) GetInterfaceName_() string {
	return "com.deepin.daemon.ImageBlur"
}

// method Delete

func (v *interfaceImageBlur) GoDelete(flags dbus.Flags, ch chan *dbus.Call, file string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Delete", flags, ch, file)
}

func (v *interfaceImageBlur) Delete(flags dbus.Flags, file string) error {
	return (<-v.GoDelete(flags, make(chan *dbus.Call, 1), file).Done).Err
}

// method Get

func (v *interfaceImageBlur) GoGet(flags dbus.Flags, ch chan *dbus.Call, source string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Get", flags, ch, source)
}

func (*interfaceImageBlur) StoreGet(call *dbus.Call) (blurred string, err error) {
	err = call.Store(&blurred)
	return
}

func (v *interfaceImageBlur) Get(flags dbus.Flags, source string) (string, error) {
	return v.StoreGet(
		<-v.GoGet(flags, make(chan *dbus.Call, 1), source).Done)
}

// signal BlurDone

func (v *interfaceImageBlur) ConnectBlurDone(cb func(imgFile string, imgBlurFile string, ok bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "BlurDone", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".BlurDone",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var imgFile string
		var imgBlurFile string
		var ok bool
		err := dbus.Store(sig.Body, &imgFile, &imgBlurFile, &ok)
		if err == nil {
			cb(imgFile, imgBlurFile, ok)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}
