// Code generated by "./generator ./org.freedesktop.notifications"; DO NOT EDIT.

package notifications

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"pkg.deepin.io/lib/dbusutil"
	"pkg.deepin.io/lib/dbusutil/proxy"
)

type Notifications interface {
	notifications // interface org.freedesktop.Notifications
	proxy.Object
}

type objectNotifications struct {
	interfaceNotifications // interface org.freedesktop.Notifications
	proxy.ImplObject
}

func NewNotifications(conn *dbus.Conn) Notifications {
	obj := new(objectNotifications)
	obj.ImplObject.Init_(conn, "org.freedesktop.Notifications", "/org/freedesktop/Notifications")
	return obj
}

type notifications interface {
	GoGetCapabilities(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetCapabilities(flags dbus.Flags) ([]string, error)
	GoNotify(flags dbus.Flags, ch chan *dbus.Call, app_name string, replaces_id uint32, app_icon string, summary string, body string, actions []string, hints map[string]dbus.Variant, expire_timeout int32) *dbus.Call
	Notify(flags dbus.Flags, app_name string, replaces_id uint32, app_icon string, summary string, body string, actions []string, hints map[string]dbus.Variant, expire_timeout int32) (uint32, error)
	GoCloseNotification(flags dbus.Flags, ch chan *dbus.Call, id uint32) *dbus.Call
	CloseNotification(flags dbus.Flags, id uint32) error
	GoGetServerInformation(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetServerInformation(flags dbus.Flags) (string, string, string, string, error)
	ConnectNotificationClosed(cb func(id uint32, reason uint32)) (dbusutil.SignalHandlerId, error)
	ConnectActionInvoked(cb func(id uint32, action_key string)) (dbusutil.SignalHandlerId, error)
}

type interfaceNotifications struct{}

func (v *interfaceNotifications) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceNotifications) GetInterfaceName_() string {
	return "org.freedesktop.Notifications"
}

// method GetCapabilities

func (v *interfaceNotifications) GoGetCapabilities(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetCapabilities", flags, ch)
}

func (*interfaceNotifications) StoreGetCapabilities(call *dbus.Call) (capabilities []string, err error) {
	err = call.Store(&capabilities)
	return
}

func (v *interfaceNotifications) GetCapabilities(flags dbus.Flags) ([]string, error) {
	return v.StoreGetCapabilities(
		<-v.GoGetCapabilities(flags, make(chan *dbus.Call, 1)).Done)
}

// method Notify

func (v *interfaceNotifications) GoNotify(flags dbus.Flags, ch chan *dbus.Call, app_name string, replaces_id uint32, app_icon string, summary string, body string, actions []string, hints map[string]dbus.Variant, expire_timeout int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Notify", flags, ch, app_name, replaces_id, app_icon, summary, body, actions, hints, expire_timeout)
}

func (*interfaceNotifications) StoreNotify(call *dbus.Call) (id uint32, err error) {
	err = call.Store(&id)
	return
}

func (v *interfaceNotifications) Notify(flags dbus.Flags, app_name string, replaces_id uint32, app_icon string, summary string, body string, actions []string, hints map[string]dbus.Variant, expire_timeout int32) (uint32, error) {
	return v.StoreNotify(
		<-v.GoNotify(flags, make(chan *dbus.Call, 1), app_name, replaces_id, app_icon, summary, body, actions, hints, expire_timeout).Done)
}

// method CloseNotification

func (v *interfaceNotifications) GoCloseNotification(flags dbus.Flags, ch chan *dbus.Call, id uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CloseNotification", flags, ch, id)
}

func (v *interfaceNotifications) CloseNotification(flags dbus.Flags, id uint32) error {
	return (<-v.GoCloseNotification(flags, make(chan *dbus.Call, 1), id).Done).Err
}

// method GetServerInformation

func (v *interfaceNotifications) GoGetServerInformation(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetServerInformation", flags, ch)
}

func (*interfaceNotifications) StoreGetServerInformation(call *dbus.Call) (name string, vendor string, version string, spec_version string, err error) {
	err = call.Store(&name, &vendor, &version, &spec_version)
	return
}

func (v *interfaceNotifications) GetServerInformation(flags dbus.Flags) (string, string, string, string, error) {
	return v.StoreGetServerInformation(
		<-v.GoGetServerInformation(flags, make(chan *dbus.Call, 1)).Done)
}

// signal NotificationClosed

func (v *interfaceNotifications) ConnectNotificationClosed(cb func(id uint32, reason uint32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "NotificationClosed", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".NotificationClosed",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id uint32
		var reason uint32
		err := dbus.Store(sig.Body, &id, &reason)
		if err == nil {
			cb(id, reason)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ActionInvoked

func (v *interfaceNotifications) ConnectActionInvoked(cb func(id uint32, action_key string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ActionInvoked", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ActionInvoked",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id uint32
		var action_key string
		err := dbus.Store(sig.Body, &id, &action_key)
		if err == nil {
			cb(id, action_key)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}
