/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.RangeStats;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.DistanceTimeLimitFunction;
import tim.prune.undo.UndoAppendPoints;

public class CreateMarkerWaypointsFunction
extends DistanceTimeLimitFunction {
    private ArrayList<DataPoint> _pointsToAdd = new ArrayList();
    private int _previousMultiple = 0;

    public CreateMarkerWaypointsFunction(App app) {
        super(app, true);
    }

    @Override
    public String getNameKey() {
        return "function.createmarkerwaypoints";
    }

    private void initMemory() {
        this._pointsToAdd.clear();
        this._previousMultiple = 0;
    }

    @Override
    protected void performFunction() {
        int n = this.getTimeLimitInSeconds();
        boolean bl = n > 0;
        double d = this.getDistanceLimitKilometres();
        boolean bl2 = d > 0.0;
        boolean bl3 = this.isHalvesSelected();
        this.initMemory();
        if (bl || bl2) {
            this.createWaypointsAtIntervals(n, d);
        } else if (bl3) {
            this.createHalfwayWaypoints();
        } else {
            return;
        }
        if (!this._pointsToAdd.isEmpty()) {
            int n2 = this._app.getTrackInfo().getTrack().getNumPoints();
            UndoAppendPoints undoAppendPoints = new UndoAppendPoints(n2);
            Field[] fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.ALTITUDE, Field.WAYPT_NAME};
            int n3 = this._pointsToAdd.size();
            DataPoint[] dataPointArray = new DataPoint[n3];
            this._pointsToAdd.toArray(dataPointArray);
            Track track = new Track(new FieldList(fieldArray), dataPointArray);
            this._app.getTrackInfo().getTrack().combine(track);
            undoAppendPoints.setNumPointsAppended(n3);
            String string = I18nManager.getTextWithNumber("confirm.pointsadded", this._pointsToAdd.size());
            this._app.completeFunction(undoAppendPoints, string);
            UpdateMessageBroker.informSubscribers();
        }
        this._dialog.dispose();
    }

    private void createWaypointsAtIntervals(int n, double d) {
        boolean bl = n > 0;
        boolean bl2 = d > 0.0;
        DataPoint dataPoint = null;
        DataPoint dataPoint2 = null;
        double d2 = 0.0;
        double d3 = 0.0;
        RangeStats rangeStats = new RangeStats();
        int n2 = this._app.getTrackInfo().getTrack().getNumPoints();
        int n3 = 0;
        while (n3 < n2) {
            dataPoint = this._app.getTrackInfo().getTrack().getPoint(n3);
            rangeStats.addPoint(dataPoint);
            if (!dataPoint.isWaypoint()) {
                if (bl) {
                    d2 = rangeStats.getMovingDurationInSeconds();
                    this.processValue(dataPoint2, d3, n, dataPoint, d2);
                } else if (bl2) {
                    d2 = rangeStats.getMovingDistanceKilometres();
                    this.processValue(dataPoint2, d3, d, dataPoint, d2);
                }
                dataPoint2 = dataPoint;
                d3 = d2;
            }
            ++n3;
        }
    }

    private void processValue(DataPoint dataPoint, double d, double d2, DataPoint dataPoint2, double d3) {
        int n = (int)Math.floor(d3 / d2);
        int n2 = this._previousMultiple + 1;
        while (n2 <= n) {
            double d4 = (double)n2 * d2 - d;
            double d5 = d3 - (double)n2 * d2;
            double d6 = d4 / (d4 + d5);
            DataPoint dataPoint3 = DataPoint.interpolate(dataPoint, dataPoint2, d6);
            dataPoint3.setFieldValue(Field.WAYPT_NAME, this.createLimitDescription(n2), false);
            this._pointsToAdd.add(dataPoint3);
            ++n2;
        }
        this._previousMultiple = n;
    }

    private void createHalfwayWaypoints() {
        int n = this._app.getTrackInfo().getTrack().getNumPoints();
        RangeStats rangeStats = new RangeStats();
        DataPoint dataPoint = null;
        int n2 = 0;
        while (n2 < n) {
            dataPoint = this._app.getTrackInfo().getTrack().getPoint(n2);
            rangeStats.addPoint(dataPoint);
            ++n2;
        }
        double d = rangeStats.getMovingDistanceKilometres();
        double d2 = rangeStats.getMovingAltitudeRange().getClimb(UnitSetLibrary.UNITS_METRES);
        double d3 = rangeStats.getMovingAltitudeRange().getDescent(UnitSetLibrary.UNITS_METRES);
        double d4 = d / 2.0;
        double d5 = d2 / 2.0;
        double d6 = d3 / 2.0;
        RangeStats rangeStats2 = new RangeStats();
        DataPoint dataPoint2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            dataPoint = this._app.getTrackInfo().getTrack().getPoint(n3);
            rangeStats2.addPoint(dataPoint);
            if (!dataPoint.isWaypoint()) {
                double d10;
                if (!bl && d > 0.0) {
                    d10 = rangeStats2.getMovingDistanceKilometres();
                    bl = this.processHalfValue(dataPoint2, d7, d4, dataPoint, d10, HalfwayType.HALF_DISTANCE);
                    d7 = d10;
                }
                if (!bl2 && d2 > 0.0) {
                    d10 = rangeStats2.getMovingAltitudeRange().getClimb(UnitSetLibrary.UNITS_METRES);
                    bl2 = this.processHalfValue(dataPoint2, d8, d5, dataPoint, d10, HalfwayType.HALF_CLIMB);
                    d8 = d10;
                }
                if (!bl3 && d3 > 0.0) {
                    d10 = rangeStats2.getMovingAltitudeRange().getDescent(UnitSetLibrary.UNITS_METRES);
                    bl3 = this.processHalfValue(dataPoint2, d9, d6, dataPoint, d10, HalfwayType.HALF_DESCENT);
                    d9 = d10;
                }
                dataPoint2 = dataPoint;
            }
            ++n3;
        }
    }

    private boolean processHalfValue(DataPoint dataPoint, double d, double d2, DataPoint dataPoint2, double d3, HalfwayType halfwayType) {
        if (d <= d2 && d3 >= d2) {
            double d4 = d2 - d;
            double d5 = d3 - d2;
            double d6 = d4 / (d4 + d5);
            DataPoint dataPoint3 = DataPoint.interpolate(dataPoint, dataPoint2, d6);
            dataPoint3.setFieldValue(Field.WAYPT_NAME, this.createHalfwayName(halfwayType), false);
            this._pointsToAdd.add(dataPoint3);
            return true;
        }
        return false;
    }

    private String createHalfwayName(HalfwayType halfwayType) {
        String string = null;
        switch (halfwayType) {
            case HALF_DISTANCE: {
                string = "distance";
                break;
            }
            case HALF_CLIMB: {
                string = "climb";
                break;
            }
            case HALF_DESCENT: {
                string = "descent";
            }
        }
        if (string != null) {
            return I18nManager.getText("dialog.markers.half." + string);
        }
        return "half";
    }

    private static enum HalfwayType {
        HALF_DISTANCE,
        HALF_CLIMB,
        HALF_DESCENT;

    }
}

