/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.StartParameter;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.changedetection.state.FileHasherStatistics;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.file.StatStatistics;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.service.scopes.VirtualFileSystemServices;
import org.gradle.internal.snapshot.impl.DirectorySnapshotterStatistics;
import org.gradle.internal.watch.options.FileSystemWatchingSettingsFinalizedProgressDetails;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.internal.watch.vfs.VfsLogging;
import org.gradle.internal.watch.vfs.WatchLogging;
import org.gradle.internal.watch.vfs.WatchMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemWatchingBuildActionRunner
implements BuildActionRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemWatchingBuildActionRunner.class);
    private final BuildOperationProgressEventEmitter eventEmitter;
    private final BuildLifecycleAwareVirtualFileSystem virtualFileSystem;
    private final StatStatistics.Collector statStatisticsCollector;
    private final FileHasherStatistics.Collector fileHasherStatisticsCollector;
    private final DirectorySnapshotterStatistics.Collector directorySnapshotterStatisticsCollector;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildActionRunner delegate;

    public FileSystemWatchingBuildActionRunner(BuildOperationProgressEventEmitter eventEmitter, BuildLifecycleAwareVirtualFileSystem virtualFileSystem, StatStatistics.Collector statStatisticsCollector, FileHasherStatistics.Collector fileHasherStatisticsCollector, DirectorySnapshotterStatistics.Collector directorySnapshotterStatisticsCollector, BuildOperationRunner buildOperationRunner, BuildActionRunner delegate) {
        this.eventEmitter = eventEmitter;
        this.virtualFileSystem = virtualFileSystem;
        this.statStatisticsCollector = statStatisticsCollector;
        this.fileHasherStatisticsCollector = fileHasherStatisticsCollector;
        this.directorySnapshotterStatisticsCollector = directorySnapshotterStatisticsCollector;
        this.buildOperationRunner = buildOperationRunner;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        boolean actuallyWatching;
        StartParameterInternal startParameter = action.getStartParameter();
        WatchMode watchFileSystemMode = startParameter.getWatchFileSystemMode();
        VfsLogging verboseVfsLogging = startParameter.isVfsVerboseLogging() ? VfsLogging.VERBOSE : VfsLogging.NORMAL;
        WatchLogging debugWatchLogging = startParameter.isWatchFileSystemDebugLogging() ? WatchLogging.DEBUG : WatchLogging.NORMAL;
        LOGGER.info("Watching the file system is configured to be {}", (Object)watchFileSystemMode.getDescription());
        if (watchFileSystemMode.isEnabled()) {
            FileSystemWatchingBuildActionRunner.dropVirtualFileSystemIfRequested(startParameter, this.virtualFileSystem);
        }
        if (verboseVfsLogging == VfsLogging.VERBOSE) {
            FileSystemWatchingBuildActionRunner.logVfsStatistics("since last build", this.statStatisticsCollector, this.fileHasherStatisticsCollector, this.directorySnapshotterStatisticsCollector);
        }
        if (action.getStartParameter().getProjectCacheDir() != null) {
            switch (watchFileSystemMode) {
                case ENABLED: {
                    throw new IllegalStateException("Enabling file system watching via --watch-fs (or via the org.gradle.vfs.watch property) with --project-cache-dir also specified is not supported; remove either option to fix this problem");
                }
                case DEFAULT: {
                    LOGGER.info("File system watching is disabled because --project-cache-dir is specified");
                    watchFileSystemMode = WatchMode.DISABLED;
                    break;
                }
            }
        }
        LOGGER.info("File system watching is {}", (Object)((actuallyWatching = this.virtualFileSystem.afterBuildStarted(watchFileSystemMode, verboseVfsLogging, debugWatchLogging, this.buildOperationRunner)) ? "active" : "inactive"));
        this.eventEmitter.emitNowForCurrent(new FileSystemWatchingSettingsFinalizedProgressDetails(){

            public boolean isEnabled() {
                return actuallyWatching;
            }
        });
        try {
            BuildActionRunner.Result result = this.delegate.run(action, buildController);
            return result;
        }
        finally {
            int maximumNumberOfWatchedHierarchies = VirtualFileSystemServices.getMaximumNumberOfWatchedHierarchies((StartParameter)startParameter);
            this.virtualFileSystem.beforeBuildFinished(watchFileSystemMode, verboseVfsLogging, debugWatchLogging, this.buildOperationRunner, maximumNumberOfWatchedHierarchies);
            if (verboseVfsLogging == VfsLogging.VERBOSE) {
                FileSystemWatchingBuildActionRunner.logVfsStatistics("during current build", this.statStatisticsCollector, this.fileHasherStatisticsCollector, this.directorySnapshotterStatisticsCollector);
            }
        }
    }

    private static void logVfsStatistics(String title, StatStatistics.Collector statStatisticsCollector, FileHasherStatistics.Collector fileHasherStatisticsCollector, DirectorySnapshotterStatistics.Collector directorySnapshotterStatisticsCollector) {
        LOGGER.warn("VFS> Statistics {}:", (Object)title);
        LOGGER.warn("VFS> > Stat: {}", (Object)statStatisticsCollector.collect());
        LOGGER.warn("VFS> > FileHasher: {}", (Object)fileHasherStatisticsCollector.collect());
        LOGGER.warn("VFS> > DirectorySnapshotter: {}", (Object)directorySnapshotterStatisticsCollector.collect());
    }

    private static void dropVirtualFileSystemIfRequested(StartParameterInternal startParameter, BuildLifecycleAwareVirtualFileSystem virtualFileSystem) {
        if (VirtualFileSystemServices.isDropVfs((StartParameter)startParameter)) {
            virtualFileSystem.invalidateAll();
        }
    }
}

