/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.signatures;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.security.internal.KeyringFilePublicKeyService;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.PublicKeyServiceChain;
import org.gradle.security.internal.SecuritySupport;

public class BuildTreeDefinedKeys {
    private final KeyringFilePublicKeyService keyService;
    private final File keyringsFile;
    private final File effectiveKeyringsFile;

    public BuildTreeDefinedKeys(File keyringsFile) {
        this.keyringsFile = keyringsFile;
        if (!keyringsFile.exists()) {
            keyringsFile = this.getAsciiKeyringsFile();
        }
        if (keyringsFile.exists()) {
            this.effectiveKeyringsFile = keyringsFile;
            this.keyService = new KeyringFilePublicKeyService(keyringsFile);
        } else {
            this.effectiveKeyringsFile = null;
            this.keyService = null;
        }
    }

    public File getBinaryKeyringsFile() {
        return this.keyringsFile;
    }

    public File getAsciiKeyringsFile() {
        return SecuritySupport.asciiArmoredFileFor((File)this.keyringsFile);
    }

    public List<PGPPublicKeyRing> loadKeys() throws IOException {
        if (this.effectiveKeyringsFile != null) {
            return SecuritySupport.loadKeyRingFile((File)this.effectiveKeyringsFile);
        }
        return Collections.emptyList();
    }

    public PublicKeyService applyTo(PublicKeyService original) {
        if (this.keyService != null) {
            return PublicKeyServiceChain.of((PublicKeyService[])new PublicKeyService[]{this.keyService, original});
        }
        return original;
    }

    public BuildTreeDefinedKeys dryRun() {
        return new BuildTreeDefinedKeys(new File(this.keyringsFile.getParentFile(), "verification-keyring-dryrun.gpg"));
    }
}

