/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.KnownImplementationSnapshot;
import org.gradle.internal.snapshot.impl.LambdaImplementationSnapshot;
import org.gradle.internal.snapshot.impl.UnknownClassloaderImplementationSnapshot;

public abstract class ImplementationSnapshot
implements ValueSnapshot {
    private static final String GENERATED_LAMBDA_CLASS_SUFFIX = "$$Lambda$";
    private final String typeName;

    public static ImplementationSnapshot of(Class<?> type, ClassLoaderHierarchyHasher classLoaderHasher) {
        String className = type.getName();
        return ImplementationSnapshot.of(className, classLoaderHasher.getClassLoaderHash(type.getClassLoader()), type.isSynthetic() && ImplementationSnapshot.isLambdaClassName(className));
    }

    public static ImplementationSnapshot of(String className, @Nullable HashCode classLoaderHash) {
        return ImplementationSnapshot.of(className, classLoaderHash, ImplementationSnapshot.isLambdaClassName(className));
    }

    private static ImplementationSnapshot of(String typeName, @Nullable HashCode classLoaderHash, boolean lambda) {
        if (classLoaderHash == null) {
            return new UnknownClassloaderImplementationSnapshot(typeName);
        }
        if (lambda) {
            return new LambdaImplementationSnapshot(typeName);
        }
        return new KnownImplementationSnapshot(typeName, classLoaderHash);
    }

    private static boolean isLambdaClassName(String className) {
        return className.contains(GENERATED_LAMBDA_CLASS_SUFFIX);
    }

    protected ImplementationSnapshot(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Nullable
    public abstract HashCode getClassLoaderHash();

    public abstract boolean isUnknown();

    @Nullable
    public abstract UnknownReason getUnknownReason();

    @Override
    public ValueSnapshot snapshot(@Nullable Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot other = snapshotter.snapshot(value);
        if (this.isSameSnapshot(other)) {
            return this;
        }
        return other;
    }

    protected abstract boolean isSameSnapshot(@Nullable Object var1);

    public static enum UnknownReason {
        LAMBDA("was implemented by the Java lambda '%s'.", "Using Java lambdas is not supported as task inputs.", "Use an (anonymous inner) class instead."),
        UNKNOWN_CLASSLOADER("was loaded with an unknown classloader (class '%s').", "Gradle cannot track the implementation for classes loaded with an unknown classloader.", "Load your class by using one of Gradle's built-in ways.");

        private final String descriptionTemplate;
        private final String reason;
        private final String solution;

        private UnknownReason(String descriptionTemplate, String reason, String solution) {
            this.descriptionTemplate = descriptionTemplate;
            this.reason = reason;
            this.solution = solution;
        }

        public String descriptionFor(ImplementationSnapshot implementationSnapshot) {
            return String.format(this.descriptionTemplate, implementationSnapshot.getTypeName());
        }

        public String getReason() {
            return this.reason;
        }

        public String getSolution() {
            return this.solution;
        }
    }
}

