/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation.internal;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.inject.annotation.AnnotationRemapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@Internal
public final class FindBugsRemapper
implements AnnotationRemapper {
    @Override
    @Nonnull
    public String getPackageName() {
        return "edu.umd.cs.findbugs.annotations";
    }

    @Override
    @Nonnull
    public List<AnnotationValue<?>> remap(AnnotationValue<?> annotation, VisitorContext visitorContext) {
        String simpleName = NameUtils.getSimpleName((String)annotation.getAnnotationName());
        if ("nullable".equalsIgnoreCase(simpleName)) {
            return Collections.singletonList(AnnotationValue.builder((String)"javax.annotation.Nullable").build());
        }
        if ("nonnull".equalsIgnoreCase(simpleName)) {
            return Collections.singletonList(AnnotationValue.builder((String)"javax.annotation.Nonnull").build());
        }
        return Collections.singletonList(annotation);
    }
}

