#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 abstract-deque
version:              0.3
visibility:           public
id:                   abstract-deque-0.3-rLZkVoavEcHj2UO8hX05l
key:                  abstract-deque-0.3-rLZkVoavEcHj2UO8hX05l
license:              BSD-3-Clause
maintainer:           rrnewton@gmail.com
author:               Ryan R. Newton
homepage:             https://github.com/rrnewton/haskell-lockfree/wiki
synopsis:             Abstract, parameterized interface to mutable Deques.
description:
    An abstract interface to highly-parameterizable queues/deques.

    Background: There exists a feature space for queues that extends between:

    * simple, single-ended, non-concurrent, bounded queues

    * double-ended, threadsafe, growable queues

    ... with important points inbetween (such as
    the queues used for work-stealing).

    This package includes an interface for Deques that allows the
    programmer to use a single API for all of the above, while using the
    type-system to select an efficient implementation given the
    requirements (using type families).

    This package also includes a simple reference implementation based
    on '\''IORef'\'' and "Data.Sequence".

category:             Data 
abi:                  3dbcfa8dddbd5d490244748b51007cd1
exposed:              True
exposed-modules:
    Data.Concurrent.Deque.Class Data.Concurrent.Deque.Debugger
    Data.Concurrent.Deque.Reference
    Data.Concurrent.Deque.Reference.DequeInstance

import-dirs:          /usr/lib/ghc-9.0.1/site-local/abstract-deque-0.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/abstract-deque-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/abstract-deque-0.3
hs-libraries:         HSabstract-deque-0.3-rLZkVoavEcHj2UO8hX05l
depends:
    array-0.5.4.0 base-4.15.0.0 containers-0.6.4.1
    random-1.2.1-AVlrOvJdpabLt5UKQZGZvR time-1.9.3

haddock-interfaces:
    /usr/share/doc/haskell-abstract-deque/html/abstract-deque.haddock

haddock-html:         /usr/share/doc/haskell-abstract-deque/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

