#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 algebraic-graphs
version:              0.5
visibility:           public
id:                   algebraic-graphs-0.5-Em1lV5viphAuJ07GovE3M
key:                  algebraic-graphs-0.5-Em1lV5viphAuJ07GovE3M
license:              MIT
copyright:            Andrey Mokhov, 2016-2019
maintainer:
    Andrey Mokhov <andrey.mokhov@gmail.com>, github: @snowleopard,
    Alexandre Moine <alexandre@moine.me>, github: @nobrakal

author:
    Andrey Mokhov <andrey.mokhov@gmail.com>, github: @snowleopard

stability:            experimental
homepage:             https://github.com/snowleopard/alga
synopsis:
    A library for algebraic graph construction and transformation

description:
    <https://github.com/snowleopard/alga Alga> is a library for algebraic construction and
    manipulation of graphs in Haskell. See <https://github.com/snowleopard/alga-paper this paper>
    for the motivation behind the library, the underlying theory and implementation details.

    The top-level module
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph.html Algebra.Graph>
    defines the main data type for /algebraic graphs/
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph.html#t:Graph Graph>,
    as well as associated algorithms. For type-safe representation and
    manipulation of /non-empty algebraic graphs/, see
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-NonEmpty.html Algebra.Graph.NonEmpty>.
    Furthermore, /algebraic graphs with edge labels/ are implemented in
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-Labelled.html Algebra.Graph.Labelled>.

    The library also provides conventional graph data structures, such as
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-AdjacencyMap.html Algebra.Graph.AdjacencyMap>
    along with its various flavours: adjacency maps specialised to graphs with
    vertices of type '\''Int'\''
    (<http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-AdjacencyIntMap.html Algebra.Graph.AdjacencyIntMap>),
    non-empty adjacency maps
    (<http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-NonEmpty-AdjacencyMap.html Algebra.Graph.NonEmpty.AdjacencyMap>),
    and adjacency maps with edge labels
    (<http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-Labelled-AdjacencyMap.html Algebra.Graph.Labelled.AdjacencyMap>).
    A large part of the API of algebraic graphs and adjacency maps is available
    through the '\''Foldable'\''-like type class
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-ToGraph.html Algebra.Graph.ToGraph>.

    The type classes defined in
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-Class.html Algebra.Graph.Class>
    and
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-HigherKinded-Class.html Algebra.Graph.HigherKinded.Class>
    can be used for polymorphic construction and manipulation of graphs.

    This is an experimental library and the API is expected to remain unstable until version 1.0.0.
    Please consider contributing to the on-going
    <https://github.com/snowleopard/alga/issues discussions on the library API>.

category:             Algebra, Algorithms, Data Structures, Graphs
abi:                  9ef5383a7219f7f2d0d1f6a63f75f716
exposed:              True
exposed-modules:
    Algebra.Graph Algebra.Graph.Acyclic.AdjacencyMap
    Algebra.Graph.AdjacencyIntMap
    Algebra.Graph.AdjacencyIntMap.Algorithm Algebra.Graph.AdjacencyMap
    Algebra.Graph.AdjacencyMap.Algorithm
    Algebra.Graph.Bipartite.Undirected.AdjacencyMap Algebra.Graph.Class
    Algebra.Graph.Export Algebra.Graph.Export.Dot
    Algebra.Graph.HigherKinded.Class Algebra.Graph.Internal
    Algebra.Graph.Label Algebra.Graph.Labelled
    Algebra.Graph.Labelled.AdjacencyMap
    Algebra.Graph.Labelled.Example.Automaton
    Algebra.Graph.Labelled.Example.Network Algebra.Graph.NonEmpty
    Algebra.Graph.NonEmpty.AdjacencyMap Algebra.Graph.Relation
    Algebra.Graph.Relation.Preorder Algebra.Graph.Relation.Reflexive
    Algebra.Graph.Relation.Symmetric Algebra.Graph.Relation.Transitive
    Algebra.Graph.ToGraph Algebra.Graph.Undirected Data.Graph.Typed

import-dirs:          /usr/lib/ghc-9.0.1/site-local/algebraic-graphs-0.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/algebraic-graphs-0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/algebraic-graphs-0.5
hs-libraries:         HSalgebraic-graphs-0.5-Em1lV5viphAuJ07GovE3M
depends:
    array-0.5.4.0 base-4.15.0.0 containers-0.6.4.1 deepseq-1.4.5.0
    mtl-2.2.2 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-algebraic-graphs/html/algebraic-graphs.haddock

haddock-html:         /usr/share/doc/haskell-algebraic-graphs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

