#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 bin
version:              0.1.1
visibility:           public
id:                   bin-0.1.1-F9LjfYUUvIkKhfbKqJbLTX
key:                  bin-0.1.1-F9LjfYUUvIkKhfbKqJbLTX
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Bin: binary natural numbers.
description:
    This package provides /binary natural numbers/ ("Data.Bin");
    also utilities to work on the type level with @DataKinds@ ("Data.Type.Bin").

    @
    data Bin
    \    = BZ       -- ^ zero
    \    | BP BinP  -- ^ non-zero

    data BinP
    \    = BE       -- ^ one
    \    | B0 BinP  -- ^ double
    \    | B1 BinP  -- ^ double plus 1
    @

    There are /ordinals/ in "Data.Bin.Pos" module, as well as
    fixed width integers in "Data.Wrd".

    Another implementation is at <https://hackage.haskell.org/package/nat>,
    this differs in naming, and provides promoted variant.

category:             Data, Dependent Types, Singletons, Math
abi:                  bc6dd45e83175c6186af7c43481674dc
exposed:              True
exposed-modules:
    Data.Bin Data.Bin.Pos Data.BinP Data.BinP.PosP Data.Type.Bin
    Data.Type.BinP Data.Wrd

hidden-modules:       TrustworthyCompat
import-dirs:          /usr/lib/ghc-9.0.1/site-local/bin-0.1.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/bin-0.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/bin-0.1.1
hs-libraries:         HSbin-0.1.1-F9LjfYUUvIkKhfbKqJbLTX
depends:
    QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn base-4.15.0.0
    dec-0.0.4-6IWSKCrJrmlBCKJQW9bDSc deepseq-1.4.5.0
    fin-0.2-6Rv3uOyifwfAnZruGlA0S
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH

haddock-interfaces:   /usr/share/doc/haskell-bin/html/bin.haddock
haddock-html:         /usr/share/doc/haskell-bin/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

