#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 broadcast-chan
version:              0.2.1.1
visibility:           public
id:                   broadcast-chan-0.2.1.1-KWmYEocFTReB0IV6ha3kUl
key:                  broadcast-chan-0.2.1.1-KWmYEocFTReB0IV6ha3kUl
license:              BSD-3-Clause
copyright:            Copyright © 2014-2019 Merijn Verstraaten
maintainer:           Merijn Verstraaten <merijn@inconsistent.nl>
author:               Merijn Verstraaten
homepage:             https://github.com/merijn/broadcast-chan
synopsis:
    Closable, fair, single-wakeup channel type that avoids 0
    reader space leaks.

description:
    __WARNING:__ While the code in this library should be fairly stable and
    production, the API is something I'\''m still working on. API changes will
    follow the PVP, but __expect__ breaking API changes in future versions!

    A closable, fair, single-wakeup channel that avoids the 0 reader space leak
    that @"Control.Concurrent.Chan"@ from base suffers from.

    The @Chan@ type from @"Control.Concurrent.Chan"@ consists of both a read
    and write end combined into a single value. This means there is always at
    least 1 read end for a @Chan@, which keeps any values written to it alive.
    This is a problem for applications/libraries that want to have a channel
    that can have zero listeners.

    Suppose we have an library that produces events and we want to let users
    register to receive events. If we use a channel and write all events to it,
    we would like to drop and garbage collect any events that take place when
    there are 0 listeners. The always present read end of @Chan@ from base
    makes this impossible. We end up with a @Chan@ that forever accumulates
    more and more events that will never get removed, resulting in a memory
    leak.

    @"BroadcastChan"@ splits channels into separate read and write ends. Any
    message written to a a channel with no existing read end is immediately
    dropped so it can be garbage collected. Once a read end is created, all
    messages written to the channel will be accessible to that read end.

    Once all read ends for a channel have disappeared and been garbage
    collected, the channel will return to dropping messages as soon as they are
    written.

    __Why should I use "BroadcastChan" over "Control.Concurrent.Chan"?__

    * @"BroadcastChan"@ is closable,

    * @"BroadcastChan"@ has no 0 reader space leak,

    * @"BroadcastChan"@ has comparable or better performance.

    __Why should I use "BroadcastChan" over various (closable) STM channels?__

    * @"BroadcastChan"@ is single-wakeup,

    * @"BroadcastChan"@ is fair,

    * @"BroadcastChan"@ performs better under contention.

category:             System
abi:                  fb99917a13cb057481c24c88da16cf6d
exposed:              True
exposed-modules:
    BroadcastChan BroadcastChan.Extra BroadcastChan.Prelude
    BroadcastChan.Throw

hidden-modules:       BroadcastChan.Internal
import-dirs:          /usr/lib/ghc-9.0.1/site-local/broadcast-chan-0.2.1.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/broadcast-chan-0.2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/broadcast-chan-0.2.1.1
hs-libraries:         HSbroadcast-chan-0.2.1.1-KWmYEocFTReB0IV6ha3kUl
depends:
    base-4.15.0.0 transformers-0.5.6.2
    unliftio-core-0.2.0.1-2baD1vXgUkB5a1NRn2rSLN

haddock-interfaces:
    /usr/share/doc/haskell-broadcast-chan/html/broadcast-chan.haddock

haddock-html:         /usr/share/doc/haskell-broadcast-chan/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

