#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 bytestring-tree-builder
version:              0.2.7.9
visibility:           public
id:                   bytestring-tree-builder-0.2.7.9-H1AM0BmcAFsKTbxpzUD31b
key:                  bytestring-tree-builder-0.2.7.9-H1AM0BmcAFsKTbxpzUD31b
license:              MIT
copyright:            (c) 2015, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/bytestring-tree-builder
synopsis:
    A very efficient ByteString builder implementation based on the binary tree

description:
    According to
    <https://github.com/nikita-volkov/bytestring-builders-benchmark the benchmarks>
    this builder implementation beats all the alternatives.
    It is especially well-suited for generating strict bytestrings,
    beating the standard builder by at least the factor of 4.

category:             ByteString
abi:                  7bee4f521195e6b4711c8927c51c0c60
exposed:              True
exposed-modules:      ByteString.TreeBuilder
hidden-modules:
    ByteString.TreeBuilder.Prelude ByteString.TreeBuilder.Poker
    ByteString.TreeBuilder.Tree

import-dirs:
    /usr/lib/ghc-9.0.1/site-local/bytestring-tree-builder-0.2.7.9

library-dirs:
    /usr/lib/ghc-9.0.1/site-local/bytestring-tree-builder-0.2.7.9

dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/bytestring-tree-builder-0.2.7.9

hs-libraries:         HSbytestring-tree-builder-0.2.7.9-H1AM0BmcAFsKTbxpzUD31b
depends:              base-4.15.0.0 bytestring-0.10.12.1 text-1.2.4.1
haddock-interfaces:
    /usr/share/doc/haskell-bytestring-tree-builder/html/bytestring-tree-builder.haddock

haddock-html:         /usr/share/doc/haskell-bytestring-tree-builder/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

