#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cassava
version:              0.5.2.0
visibility:           public
id:                   cassava-0.5.2.0-BRuzc4Wtv5A4PUOtXG2WXL
key:                  cassava-0.5.2.0-BRuzc4Wtv5A4PUOtXG2WXL
license:              BSD-3-Clause
copyright:
    (c) 2012 Johan Tibell
    (c) 2012 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           hvr@gnu.org
author:               Johan Tibell
homepage:             https://github.com/hvr/cassava
synopsis:             A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.

    @cassava@'\''s API includes support for

    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")

    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:

    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"

    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.

category:             Text, Web, CSV
abi:                  afb06d916a90cc63fc8999f6b445ffb9
exposed:              True
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming

hidden-modules:
    Data.Csv.Conversion Data.Csv.Conversion.Internal Data.Csv.Encoding
    Data.Csv.Types Data.Csv.Util

import-dirs:          /usr/lib/ghc-9.0.1/site-local/cassava-0.5.2.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/cassava-0.5.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/cassava-0.5.2.0
hs-libraries:         HScassava-0.5.2.0-BRuzc4Wtv5A4PUOtXG2WXL
depends:
    Only-0.1-9WQtvuoNUx8JT3u0emjG9g array-0.5.4.0
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1 deepseq-1.4.5.0
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    scientific-0.3.7.0-LvVousZ2ZB29j7oXDdeCGV text-1.2.4.1
    text-short-0.1.4-FOhkAXI3iYvEwvBO16tzUF transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:   /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html:         /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

