#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cheapskate
version:              0.1.1.2
visibility:           public
id:                   cheapskate-0.1.1.2-AM3fuGr7RT099fQQvw19Pc
key:                  cheapskate-0.1.1.2-AM3fuGr7RT099fQQvw19Pc
license:              BSD-3-Clause
copyright:            (C) 2012-2013 John MacFarlane
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
homepage:             http://github.com/jgm/cheapskate
synopsis:             Experimental markdown processor.
description:
    This is an experimental Markdown processor in pure
    Haskell.  It aims to process Markdown efficiently and in
    the most forgiving possible way.  It is designed to deal
    with any input, including garbage, with linear
    performance.  Output is sanitized by default for
    protection against XSS attacks.

    Several markdown extensions are implemented, including
    fenced code blocks, significant list start numbers, and
    autolinked URLs.  See README.markdown for details.

category:             Text
abi:                  32be0505dfcd944c4c91fa2b3b5b2e9f
exposed:              True
exposed-modules:
    Cheapskate Cheapskate.Html Cheapskate.Parse Cheapskate.Types

hidden-modules:
    Cheapskate.Util Cheapskate.Inlines Cheapskate.ParserCombinators
    Paths_cheapskate

import-dirs:          /usr/lib/ghc-9.0.1/site-local/cheapskate-0.1.1.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/cheapskate-0.1.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/cheapskate-0.1.1.2
hs-libraries:         HScheapskate-0.1.1.2-AM3fuGr7RT099fQQvw19Pc
depends:
    base-4.15.0.0 blaze-html-0.9.1.2-K4t4PnwLIn1K06QqwerVVe
    containers-0.6.4.1 data-default-0.7.1.1-J3rzpkFy8Zd5Q7EBzVOXXF
    deepseq-1.4.5.0 mtl-2.2.2 syb-0.7.2.1-JG4kH6P0JxMKeIFdjWhhC8
    text-1.2.4.1 uniplate-1.6.13-KUT1WtoOy8j9HS4rdFCD1G
    xss-sanitize-0.3.7-Jpq34eoOmK94p0B6NPNA9U

haddock-interfaces:   /usr/share/doc/haskell-cheapskate/html/cheapskate.haddock
haddock-html:         /usr/share/doc/haskell-cheapskate/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

