#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 chell
version:              0.5
visibility:           public
id:                   chell-0.5-8TAORpMJ4bH3aP1Ab2pmAn
key:                  chell-0.5-8TAORpMJ4bH3aP1Ab2pmAn
license:              MIT
maintainer:           Chris Martin, Julie Moronuki
author:               John Millikin <john@john-millikin.com>
homepage:             https://github.com/typeclasses/chell
synopsis:             A simple and intuitive library for automated testing.
description:
    Chell is a simple and intuitive library for automated testing. It natively
    supports assertion-based testing, and can use companion libraries
    such as @chell-quickcheck@ to support more complex testing strategies.

    An example test suite, which verifies the behavior of artithmetic operators.

    @
    &#x7b;-\# LANGUAGE TemplateHaskell \#-&#x7d;

    import Test.Chell

    tests_Math :: Suite
    tests_Math = suite \"math\"
    &#x20;   [ test_Addition
    &#x20;   , test_Subtraction
    &#x20;   ]

    test_Addition :: Test
    test_Addition = assertions \"addition\" $ do
    &#x20;   $expect (equal (2 + 1) 3)
    &#x20;   $expect (equal (1 + 2) 3)

    test_Subtraction :: Test
    test_Subtraction = assertions \"subtraction\" $ do
    &#x20;   $expect (equal (2 - 1) 1)
    &#x20;   $expect (equal (1 - 2) (-1))

    main :: IO ()
    main = defaultMain [tests_Math]
    @

    @
    $ ghc --make chell-example.hs
    $ ./chell-example
    PASS: 2 tests run, 2 tests passed
    @

category:             Testing
abi:                  612fcaa2d5d9c25ca3e9b4ca9eb70879
exposed:              True
exposed-modules:      Test.Chell
hidden-modules:       Test.Chell.Main Test.Chell.Output Test.Chell.Types
import-dirs:          /usr/lib/ghc-9.0.1/site-local/chell-0.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/chell-0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/chell-0.5
hs-libraries:         HSchell-0.5-8TAORpMJ4bH3aP1Ab2pmAn
depends:
    ansi-terminal-0.11-Kvq5JBN7BE16HA1JfrRBzw base-4.15.0.0
    bytestring-0.10.12.1 options-1.2.1.1-DZBVVKlL56uDMRIhppwNtl
    patience-0.3-AEFu8V1Gv6zFbJllaUIZ0K
    random-1.2.1-AVlrOvJdpabLt5UKQZGZvR template-haskell-2.17.0.0
    text-1.2.4.1 transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-chell/html/chell.haddock
haddock-html:         /usr/share/doc/haskell-chell/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

