#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.12.1
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.12.1-5Zbo4msoNxCLag2BXw8c3n-haskell-ci-internal

key:
    haskell-ci-0.12.1-5Zbo4msoNxCLag2BXw8c3n-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  85b1064faaf4f0ad787ecc488fe7fbbf
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cli HaskellCI.Compiler
    HaskellCI.Config HaskellCI.Config.ConstraintSet
    HaskellCI.Config.CopyFields HaskellCI.Config.Docspec
    HaskellCI.Config.Doctest HaskellCI.Config.Dump
    HaskellCI.Config.Folds HaskellCI.Config.HLint
    HaskellCI.Config.Installed HaskellCI.Config.Jobs
    HaskellCI.Config.PackageScope HaskellCI.Config.Ubuntu
    HaskellCI.Config.Validity HaskellCI.Diagnostics HaskellCI.Error
    HaskellCI.GitConfig HaskellCI.GitHub HaskellCI.GitHub.Yaml
    HaskellCI.HeadHackage HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.0.1/site-local/haskell-ci-0.12.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/haskell-ci-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/haskell-ci-0.12.1
hs-libraries:
    HShaskell-ci-0.12.1-5Zbo4msoNxCLag2BXw8c3n-haskell-ci-internal

depends:
    Cabal-3.4.0.0 HsYAML-0.2.1.0-CiDWRtG0BD9Fs3vGAxzmWh
    ShellCheck-0.7.2-46Cn7Sah2M14zcXpTRxlga
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    base-compat-0.11.2-EfuzzJ3SbjR74eBdJgKfBC
    base16-bytestring-1.0.1.0-GJhpZd6NgioKWj3pmrwD4Y binary-0.8.8.0
    bytestring-0.10.12.1
    cabal-install-parsers-0.4.2-6yLz9ucZwJpCNrbl3Dib4z
    containers-0.6.4.1
    cryptohash-sha256-0.11.102.1-3Bu9IQ0MhqyI4u88Rxe1M9 deepseq-1.4.5.0
    directory-1.3.6.1 exceptions-0.10.4 filepath-1.4.2.1
    generic-lens-lite-0.1-aPsb3sfjaIJFPaRoTUgDk
    indexed-traversable-0.1.1-K0YsJRCif6Q7nMYcYE7GvA
    indexed-traversable-instances-0.1-77RbIbVOkYl1vxiP35RFOP
    ini-0.4.1-K5tNZCuhp5rEOwkEo41iEw
    lattices-2.0.2-BxuvjotPmGK9VdoTukshSj mtl-2.2.2
    network-uri-2.6.4.1-32se5oU1b9O36LNwPHSlHj
    optparse-applicative-0.16.1.0-2gAu0ltAuRsE34mFhrRUQs
    parsec-3.1.14.0 pretty-1.1.3.6 process-1.6.11.0
    temporary-1.3-1fpZ6Xm8biD79YIGypkFzm text-1.2.4.1
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    zinza-0.2-3MplwcUekWJIOApclISErk

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

