#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-lib
version:              1.4.3
visibility:           public
id:                   clash-lib-1.4.3-25zgD1vp6KG34swJ7ISD64
key:                  clash-lib-1.4.3-25zgD1vp6KG34swJ7ISD64
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2019, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - As a library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * The CoreHW internal language: SystemF + Letrec + Case-decomposition

    * The normalisation process that brings CoreHW in a normal form that can be
    converted to a netlist

    * Blackbox/Primitive Handling


    Front-ends (for: parsing, typecheck, etc.) are provided by separate packages:

    * <https://hackage.haskell.org/package/clash-ghc GHC/Haskell Frontend>

    * <https://github.com/christiaanb/Idris-dev Idris Frontend>


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  080196a5120ddd10157fa7d3e0ce15c2
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation.ClashLib Clash.Backend
    Clash.Backend.SystemVerilog Clash.Backend.VHDL
    Clash.Backend.Verilog Clash.Core.DataCon Clash.Core.EqSolver
    Clash.Core.Evaluator.Types Clash.Core.FreeVars Clash.Core.Literal
    Clash.Core.Name Clash.Core.PartialEval
    Clash.Core.PartialEval.AsTerm Clash.Core.PartialEval.Monad
    Clash.Core.PartialEval.NormalForm Clash.Core.Pretty
    Clash.Core.Subst Clash.Core.Term Clash.Core.TermInfo
    Clash.Core.TermLiteral Clash.Core.TermLiteral.TH
    Clash.Core.Termination Clash.Core.TyCon Clash.Core.Type
    Clash.Core.TysPrim Clash.Core.Util Clash.Core.Var Clash.Core.VarEnv
    Clash.Debug Clash.Driver Clash.Driver.Manifest Clash.Driver.Types
    Clash.Edalize.Edam Clash.Netlist Clash.Netlist.BlackBox
    Clash.Netlist.BlackBox.Parser Clash.Netlist.BlackBox.Types
    Clash.Netlist.BlackBox.Util Clash.Netlist.Id
    Clash.Netlist.Id.Common Clash.Netlist.Id.Internal
    Clash.Netlist.Id.SystemVerilog Clash.Netlist.Id.VHDL
    Clash.Netlist.Id.Verilog Clash.Netlist.Types Clash.Netlist.Util
    Clash.Normalize Clash.Normalize.DEC
    Clash.Normalize.PrimitiveReductions Clash.Normalize.Strategy
    Clash.Normalize.Transformations Clash.Normalize.Types
    Clash.Normalize.Util Clash.Pretty Clash.Primitives.DSL
    Clash.Primitives.GHC.Int Clash.Primitives.GHC.Literal
    Clash.Primitives.GHC.Word Clash.Primitives.Intel.ClockGen
    Clash.Primitives.Sized.ToInteger Clash.Primitives.Sized.Vector
    Clash.Primitives.Types Clash.Primitives.Util
    Clash.Primitives.Verification Clash.Rewrite.Combinators
    Clash.Rewrite.Types Clash.Rewrite.Util Clash.Rewrite.WorkFree
    Clash.Unique Clash.Util Clash.Util.Graph Clash.Util.Interpolate
    Data.Text.Prettyprint.Doc.Extra

hidden-modules:
    Clash.Annotations.TopEntity.Extra Control.Applicative.Extra
    Data.Aeson.Extra Data.List.Extra Data.Map.Ordered.Extra
    Data.Primitive.ByteArray.Extra Data.Semigroup.Monad.Extra
    Data.Set.Ordered.Extra GHC.BasicTypes.Extra GHC.SrcLoc.Extra
    Paths_clash_lib

import-dirs:          /usr/lib/ghc-9.0.1/site-local/clash-lib-1.4.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/clash-lib-1.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/clash-lib-1.4.3
hs-libraries:         HSclash-lib-1.4.3-25zgD1vp6KG34swJ7ISD64
depends:
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    aeson-pretty-0.8.9-AXFdNE1ZWy326pjreSMahS
    ansi-terminal-0.11-Kvq5JBN7BE16HA1JfrRBzw array-0.5.4.0
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    base16-bytestring-1.0.1.0-GJhpZd6NgioKWj3pmrwD4Y binary-0.8.8.0
    bytestring-0.10.12.1 clash-prelude-1.4.3-Ab2RByk2je67BhP58PU6Zy
    concurrent-supply-0.1.8-2iy6ZkAlOvLJsfDE5ZGiOJ containers-0.6.4.1
    cryptohash-sha256-0.11.102.1-3Bu9IQ0MhqyI4u88Rxe1M9
    data-binary-ieee754-0.4.4-1uzt85nFoxu5Mgq2DE5oph
    data-default-0.7.1.1-J3rzpkFy8Zd5Q7EBzVOXXF deepseq-1.4.5.0
    directory-1.3.6.1 dlist-1.0-UyN3fdgb0F8e8xXMrElbD
    errors-2.3.0-FhBmHY7sMIf8wTT2E4ozOx exceptions-0.10.4
    extra-1.7.10-32H3SA4Yf8dI1sU3NgBQjm filepath-1.4.2.1 ghc-9.0.1
    ghc-bignum-1.0 ghc-boot-th-9.0.1
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    haskell-src-meta-0.8.7-H1zwwQr03DHfgyfZfwBvc
    hint-0.9.0.4-Cx90noHvcwMCh5ipcQpE4q
    interpolate-0.2.1-GfE643NwNhjIUk5Z6JtT86
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO mtl-2.2.2
    ordered-containers-0.2.2-HFNNhie1Aw64sPyEbOR86d
    parsers-0.12.10-Fygk0UygGWIJGasEEw3Ph0
    pretty-show-1.10-G4SfLXvOfw8HasEUHDrqxD
    prettyprinter-1.7.1-163EeBePjHLIFZcbZybr4n
    primitive-0.7.2.0-LNBP19Yyt8R6V7t6f1oEAz process-1.6.11.0
    reducers-3.12.4-70B69vnhYAA2xLBEck6pAs template-haskell-2.17.0.0
    temporary-1.3-1fpZ6Xm8biD79YIGypkFzm
    terminal-size-0.3.2.1-8rLUbNor4uN6iQgtxjW6lw text-1.2.4.1
    text-show-3.9.1-GgBPyCZdLcK89SWfHyFrwi time-1.9.3
    transformers-0.5.6.2 trifecta-2.1.1-J5FWuOR1IcuCeBtaItH8Mh
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3
    vector-binary-instances-0.2.5.2-8VSwcBKni1V7gPTwA2kOZW

haddock-interfaces:   /usr/share/doc/haskell-clash-lib/html/clash-lib.haddock
haddock-html:         /usr/share/doc/haskell-clash-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

