#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-prelude
version:              1.4.3
visibility:           public
id:                   clash-prelude-1.4.3-Ab2RByk2je67BhP58PU6Zy
key:                  clash-prelude-1.4.3-Ab2RByk2je67BhP58PU6Zy
license:              BSD-2-Clause
copyright:
    Copyright © 2013-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - Prelude library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Prelude library containing datatypes and functions for circuit design

    To use the library:

    * Import "Clash.Prelude"

    * Alternatively, if you want to explicitly route clock and reset ports,
    for more straightforward multi-clock designs, you can import the
    "Clash.Explicit.Prelude" module. Note that you should not import
    "Clash.Prelude" and "Clash.Explicit.Prelude" at the same time as they
    have overlapping definitions.

    A preliminary version of a tutorial can be found in "Clash.Tutorial", for a
    general overview of the library you should however check out "Clash.Prelude".
    Some circuit examples can be found in "Clash.Examples".

category:             Hardware
abi:                  7ea1ad9c141f69f3262d7db31f6634b4
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation
    Clash.Annotations.BitRepresentation.Deriving
    Clash.Annotations.BitRepresentation.Internal
    Clash.Annotations.BitRepresentation.Util
    Clash.Annotations.Primitive Clash.Annotations.SynthesisAttributes
    Clash.Annotations.TH Clash.Annotations.TopEntity
    Clash.Class.AutoReg Clash.Class.BitPack Clash.Class.Exp
    Clash.Class.HasDomain Clash.Class.HasDomain.CodeGen
    Clash.Class.HasDomain.Common Clash.Class.HasDomain.HasSingleDomain
    Clash.Class.HasDomain.HasSpecificDomain Clash.Class.Num
    Clash.Class.Parity Clash.Class.Resize Clash.Clocks
    Clash.Clocks.Deriving Clash.Examples Clash.Explicit.BlockRam
    Clash.Explicit.BlockRam.File Clash.Explicit.DDR
    Clash.Explicit.Mealy Clash.Explicit.Moore Clash.Explicit.Prelude
    Clash.Explicit.Prelude.Safe Clash.Explicit.RAM Clash.Explicit.ROM
    Clash.Explicit.ROM.File Clash.Explicit.Reset Clash.Explicit.Signal
    Clash.Explicit.Signal.Delayed Clash.Explicit.SimIO
    Clash.Explicit.Synchronizer Clash.Explicit.Testbench
    Clash.Explicit.Verification Clash.HaskellPrelude Clash.Hidden
    Clash.Intel.ClockGen Clash.Intel.DDR Clash.Magic Clash.NamedTypes
    Clash.Prelude Clash.Prelude.BitIndex Clash.Prelude.BitReduction
    Clash.Prelude.BlockRam Clash.Prelude.BlockRam.File
    Clash.Prelude.DataFlow Clash.Prelude.Mealy Clash.Prelude.Moore
    Clash.Prelude.RAM Clash.Prelude.ROM Clash.Prelude.ROM.File
    Clash.Prelude.Safe Clash.Prelude.Testbench Clash.Promoted.Nat
    Clash.Promoted.Nat.Literals Clash.Promoted.Nat.TH
    Clash.Promoted.Nat.Unsafe Clash.Promoted.Symbol Clash.Signal
    Clash.Signal.BiSignal Clash.Signal.Bundle Clash.Signal.Delayed
    Clash.Signal.Delayed.Bundle Clash.Signal.Delayed.Internal
    Clash.Signal.Internal Clash.Signal.Internal.Ambiguous
    Clash.Signal.Trace Clash.Sized.BitVector Clash.Sized.Fixed
    Clash.Sized.Index Clash.Sized.Internal.BitVector
    Clash.Sized.Internal.Index Clash.Sized.Internal.Mod
    Clash.Sized.Internal.Signed Clash.Sized.Internal.Unsigned
    Clash.Sized.RTree Clash.Sized.Signed Clash.Sized.Unsigned
    Clash.Sized.Vector Clash.Tutorial Clash.Verification
    Clash.Verification.DSL Clash.Verification.Internal
    Clash.Verification.PrettyPrinters Clash.XException
    Clash.XException.Internal Clash.XException.TH Clash.Xilinx.ClockGen
    Clash.Xilinx.DDR

hidden-modules:
    Clash.Class.AutoReg.Instances Clash.Class.AutoReg.Internal
    Clash.Class.BitPack.Internal Clash.CPP Clash.Examples.Internal
    Clash.Signal.Bundle.Internal Language.Haskell.TH.Compat
    Paths_clash_prelude

import-dirs:          /usr/lib/ghc-9.0.1/site-local/clash-prelude-1.4.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/clash-prelude-1.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/clash-prelude-1.4.3
hs-libraries:         HSclash-prelude-1.4.3-Ab2RByk2je67BhP58PU6Zy
depends:
    QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn array-0.5.4.0
    arrows-0.4.4.2-JBmGDTo1g5J1WozpAjNzf7 base-4.15.0.0
    bifunctors-5.5.11-3MgHowlkzBNDa84Pzdaw4w binary-0.8.8.0
    bytestring-0.10.12.1 constraints-0.13-5JSJPJLXJuiAjSg7EqNkv8
    containers-0.6.4.1 data-binary-ieee754-0.4.4-1uzt85nFoxu5Mgq2DE5oph
    data-default-class-0.1.2.0-LBmwYNzg9cwLSaLiX5AQfC deepseq-1.4.5.0
    ghc-bignum-1.0 ghc-prim-0.7.0
    ghc-typelits-extra-0.4.3-6nYo8xBOFPO1WRumGXicto
    ghc-typelits-knownnat-0.7.6-JCXLiekWZO1GO4MCi4cayR
    ghc-typelits-natnormalise-0.7.6-CX5GdXkZxBv6P4PbepuCpT
    half-0.3.1-76Ia61sNxf53I73xlsxmdK
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    interpolate-0.2.1-GfE643NwNhjIUk5Z6JtT86
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO
    recursion-schemes-5.2.2.1-GIOcr6kiJRwF7IpLuwEglM
    reflection-2.1.6-6u7lgYKOoJRIaoCwDQXeMZ
    singletons-3.0-Jt8unaXUKj46TY8PMZwo6X template-haskell-2.17.0.0
    text-1.2.4.1 text-show-3.9.1-GgBPyCZdLcK89SWfHyFrwi
    th-abstraction-0.4.3.0-DBpnRpG8EZgFebz88L1kOA
    th-lift-0.8.2-F0VVOrB5SZgFNS1AEtieR9
    th-orphans-0.13.12-CIiV6ANSJ2s3vFxEOqiA1U time-1.9.3
    transformers-0.5.6.2 type-errors-0.2.0.0-IzaGRHvd7lK4DTHTKKXN4O
    uniplate-1.6.13-KUT1WtoOy8j9HS4rdFCD1G
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:
    /usr/share/doc/haskell-clash-prelude/html/clash-prelude.haddock

haddock-html:         /usr/share/doc/haskell-clash-prelude/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

