#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 crypto-api
version:              0.13.3
visibility:           public
id:                   crypto-api-0.13.3-K4D4TqlwTtyDpSHz3hLF4b
key:                  crypto-api-0.13.3-K4D4TqlwTtyDpSHz3hLF4b
license:              BSD-3-Clause
copyright:            Thomas DuBuisson <thomas.dubuisson@gmail.com>
maintainer:           Thomas DuBuisson <thomas.dubuisson@gmail.com>
author:
    Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)

stability:            stable
homepage:             https://github.com/TomMD/crypto-api
synopsis:             A generic interface for cryptographic operations
description:
    A generic interface for cryptographic operations (hashes, ciphers, randomness).
    Maintainers of hash and cipher implementations are
    encouraged to add instances for the classes defined
    in Crypto.Classes.  Crypto users are similarly
    encouraged to use the interfaces defined in the Classes
    module.
    Any concepts or functions of general use to more than
    one cryptographic algorithm (ex: padding) is within
    scope of this package.

category:             Data, Cryptography
abi:                  edbde2f992d264a6815a62058e10534e
exposed:              True
exposed-modules:
    Crypto.Classes Crypto.Classes.Exceptions Crypto.HMAC Crypto.Modes
    Crypto.Padding Crypto.Random Crypto.Types Crypto.Util

hidden-modules:       Crypto.CPoly
import-dirs:          /usr/lib/ghc-9.0.1/site-local/crypto-api-0.13.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/crypto-api-0.13.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/crypto-api-0.13.3
hs-libraries:         HScrypto-api-0.13.3-K4D4TqlwTtyDpSHz3hLF4b
depends:
    base-4.15.0.0 bytestring-0.10.12.1
    cereal-0.5.8.2-61j1a5W2ABqDRz8HqQdVx7
    entropy-0.4.1.7-66OkMQHXKESGwpio7bQXje
    tagged-0.8.6.1-FL843C40q4d1DeuwYADr25 transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-crypto-api/html/crypto-api.haddock
haddock-html:         /usr/share/doc/haskell-crypto-api/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

