#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 crypto-api-tests
version:              0.3
visibility:           public
id:                   crypto-api-tests-0.3-DUVT7FfjnG93af0wKzM5EW
key:                  crypto-api-tests-0.3-DUVT7FfjnG93af0wKzM5EW
license:              BSD-3-Clause
copyright:            Thomas DuBuisson <thomas.dubuisson@gmail.com>
maintainer:           Thomas DuBuisson <thomas.dubuisson@gmail.com>
author:               Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability:            stable
homepage:             http://trac.haskell.org/crypto-api/wiki
synopsis:             A test framework and KATs for cryptographic operations.
description:
    A test framework for hash and cipher operations using
    the crypto-api interface.  Known answer tests (KATs)
    for common cryptographic algorithms are included.
    Patches welcome (both adding KATs for more algorithms
    or property tests for classes of algorithms).

category:             Data, Cryptography
abi:                  28fc75d79c5f8f564a9082c108b1fadf
exposed:              True
exposed-modules:
    Test.AES Test.Crypto Test.HMAC Test.MD5 Test.ParseNistKATs Test.SHA
    Test.TwoFish

hidden-modules:       Paths_crypto_api_tests
import-dirs:          /usr/lib/ghc-9.0.1/site-local/crypto-api-tests-0.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/crypto-api-tests-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/crypto-api-tests-0.3
hs-libraries:         HScrypto-api-tests-0.3-DUVT7FfjnG93af0wKzM5EW
depends:
    HUnit-1.6.2.0-2lDDmQCEetY9OrwZ2lDZMS
    QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn base-4.15.0.0
    bytestring-0.10.12.1 cereal-0.5.8.2-61j1a5W2ABqDRz8HqQdVx7
    crypto-api-0.13.3-K4D4TqlwTtyDpSHz3hLF4b directory-1.3.6.1
    filepath-1.4.2.1 test-framework-0.8.2.0-InIxjlaLDti8DjYJMiiCBZ
    test-framework-hunit-0.3.0.2-2Q2WNPaFJRG886pHeBEAlm
    test-framework-quickcheck2-0.3.0.5-ASYJfoVm4EcAQwtJsON5yy

haddock-interfaces:
    /usr/share/doc/haskell-crypto-api-tests/html/crypto-api-tests.haddock

haddock-html:         /usr/share/doc/haskell-crypto-api-tests/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

