#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 crypto-enigma
version:              0.1.1.6
visibility:           public
id:                   crypto-enigma-0.1.1.6-L9HSowTLvl8JfFTHzBWwp7
key:                  crypto-enigma-0.1.1.6-L9HSowTLvl8JfFTHzBWwp7
license:              BSD-3-Clause
copyright:            (c) 2014-2019 Roy Levien
maintainer:           royl@aldaron.com
author:               Roy Levien
homepage:             https://github.com/orome/crypto-enigma-hs
synopsis:             An Enigma machine simulator with display. 
description:
    The crypto-enigma package is an Enigma machine simulator
    with rich display and machine state details.

    Currently support is only provided for the machine models in most widespread general use
    during the war years: the I, M3, and M4.

    For basic functionality, including some introspection of machine state
    and the mappings performed, simply

    > > import Crypto.Enigma

    For richer display functionality additionally

    > > import Crypto.Enigma.Display

    (Note that this package assumes support for combining Unicode, without which some output may
    appear garbled.)

category:             Cryptography, Education
abi:                  076c7d69eb137c321fe968fda856fcfc
exposed:              True
exposed-modules:      Crypto.Enigma Crypto.Enigma.Display
hidden-modules:       Crypto.Enigma.Utils
import-dirs:          /usr/lib/ghc-9.0.1/site-local/crypto-enigma-0.1.1.6
library-dirs:         /usr/lib/ghc-9.0.1/site-local/crypto-enigma-0.1.1.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/crypto-enigma-0.1.1.6
hs-libraries:         HScrypto-enigma-0.1.1.6-L9HSowTLvl8JfFTHzBWwp7
depends:
    base-4.15.0.0 containers-0.6.4.1
    split-0.2.3.4-DqRCEXcI8QnJvOh9Kk2yn3 text-1.2.4.1

haddock-interfaces:
    /usr/share/doc/haskell-crypto-enigma/html/crypto-enigma.haddock

haddock-html:         /usr/share/doc/haskell-crypto-enigma/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

