#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cryptonite-conduit
version:              0.2.2
visibility:           public
id:                   cryptonite-conduit-0.2.2-8oA3ogBB9bA8OqaWRLJT9A
key:                  cryptonite-conduit-0.2.2-8oA3ogBB9bA8OqaWRLJT9A
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           vincent@snarc.org
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/haskell-crypto/cryptonite-conduit
synopsis:             cryptonite conduit
description:
    Conduit bridge for cryptonite

    For now only provide a conduit version for hash and hmac, but
    with contribution, this could provide cipher conduits too,
    and probably other things.

category:             Cryptography, Conduit
abi:                  5ea85afeb4e8e1ff1100542e8223ef04
exposed:              True
exposed-modules:
    Crypto.Cipher.ChaChaPoly1305.Conduit Crypto.Hash.Conduit
    Crypto.MAC.HMAC.Conduit Crypto.PubKey.ECIES.Conduit

import-dirs:          /usr/lib/ghc-9.0.1/site-local/cryptonite-conduit-0.2.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/cryptonite-conduit-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/cryptonite-conduit-0.2.2
hs-libraries:         HScryptonite-conduit-0.2.2-8oA3ogBB9bA8OqaWRLJT9A
depends:
    base-4.15.0.0 bytestring-0.10.12.1
    conduit-1.3.4.2-AchFtERdZ63E4BSigaitpI
    conduit-extra-1.3.5-IgmaX557TTAKniYRnNEHGm
    cryptonite-0.29-19SjDRwWNox27CMfesQpq4 exceptions-0.10.4
    memory-0.16.0-CGaPOmXCTce28vOCDDnDFr
    resourcet-1.2.4.3-DSdH8WNuZw9AkjYvTicAaV transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-cryptonite-conduit/html/cryptonite-conduit.haddock

haddock-html:         /usr/share/doc/haskell-cryptonite-conduit/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

