#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dbus
version:              1.2.21
visibility:           public
id:                   dbus-1.2.21-51CZLXkyvGcE14UAn0m6oF
key:                  dbus-1.2.21-51CZLXkyvGcE14UAn0m6oF
license:              Apache-2.0
maintainer:           Andrey Sverdlichenko <blaze@ruddy.ru>
author:               John Millikin <john@john-millikin.com>
stability:            experimental
homepage:             https://github.com/rblaze/haskell-dbus#readme
synopsis:             A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.

    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.

    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.

    Example: connect to the session bus, and get a list of active names.

    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;

    import Data.List (sort)
    import DBus
    import DBus.Client

    main = do
    &#x20;   client <- connectSession
    &#x20;
    &#x20;   -- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;
    &#x20;   -- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   -- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;
    &#x20;   -- Print each name on a line, sorted so reserved names are below
    &#x20;   -- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @

    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver

category:             Network, Desktop
abi:                  5c1ec235568923c69f60c0143cce625c
exposed:              True
exposed-modules:
    DBus DBus.Client DBus.Generation DBus.Internal.Address
    DBus.Internal.Message DBus.Internal.Types DBus.Internal.Wire
    DBus.Introspection DBus.Introspection.Parse
    DBus.Introspection.Render DBus.Introspection.Types DBus.Socket
    DBus.TH DBus.Transport

import-dirs:          /usr/lib/ghc-9.0.1/site-local/dbus-1.2.21
library-dirs:         /usr/lib/ghc-9.0.1/site-local/dbus-1.2.21
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/dbus-1.2.21
hs-libraries:         HSdbus-1.2.21-51CZLXkyvGcE14UAn0m6oF
depends:
    base-4.15.0.0 bytestring-0.10.12.1
    cereal-0.5.8.2-61j1a5W2ABqDRz8HqQdVx7
    conduit-1.3.4.2-AchFtERdZ63E4BSigaitpI containers-0.6.4.1
    deepseq-1.4.5.0 exceptions-0.10.4 filepath-1.4.2.1
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO
    network-3.1.2.2-9BU8QqWnKeP98A8KvbSili parsec-3.1.14.0
    random-1.2.1-AVlrOvJdpabLt5UKQZGZvR
    split-0.2.3.4-DqRCEXcI8QnJvOh9Kk2yn3 template-haskell-2.17.0.0
    text-1.2.4.1 th-lift-0.8.2-F0VVOrB5SZgFNS1AEtieR9
    transformers-0.5.6.2 unix-2.7.2.2
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3
    xml-conduit-1.9.1.1-6pgp6KEeQtY9ZzjKhWpcJ6
    xml-types-0.3.8-144bFK4Wa4uGyLKj6w2QbB

haddock-interfaces:   /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html:         /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

