#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dyre
version:              0.9.1
visibility:           public
id:                   dyre-0.9.1-2IgYiIle1Y4H69hy9uBwZA
key:                  dyre-0.9.1-2IgYiIle1Y4H69hy9uBwZA
license:              BSD-3-Clause
copyright:            (c) 2011-2019 Will Donnelly, Fraser Tweedale
maintainer:           Fraser Tweedale <frase@frase.id.au>
author:               Will Donnelly
stability:            beta
homepage:             http://github.com/willdonnelly/dyre
synopsis:             Dynamic reconfiguration in Haskell
description:
    Dyre implements dynamic reconfiguration facilities after the
    style of Xmonad. Dyre aims to be as simple as possible without
    sacrificing features, and places an emphasis on simplicity of
    integration with an application.
    A full introduction with a complete example project can be found
    in the documentation for '\''Config.Dyre'\''

category:             Development, Configuration
abi:                  0d0c84df99301fdbcc5d173ab55c96c7
exposed:              True
exposed-modules:
    Config.Dyre Config.Dyre.Compat Config.Dyre.Compile
    Config.Dyre.Options Config.Dyre.Params Config.Dyre.Paths
    Config.Dyre.Relaunch

import-dirs:          /usr/lib/ghc-9.0.1/site-local/dyre-0.9.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/dyre-0.9.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/dyre-0.9.1
hs-libraries:         HSdyre-0.9.1-2IgYiIle1Y4H69hy9uBwZA
depends:
    base-4.15.0.0 binary-0.8.8.0 directory-1.3.6.1
    executable-path-0.0.3.1-Gi8UsVQRFScIwLNgvGtMvt filepath-1.4.2.1
    io-storage-0.3-2ddpgUdfQJh6nEf8dpiKhL process-1.6.11.0 time-1.9.3
    unix-2.7.2.2 xdg-basedir-0.2.2-FxvLd0PtCIDHWciCXDjKP6

haddock-interfaces:   /usr/share/doc/haskell-dyre/html/dyre.haddock
haddock-html:         /usr/share/doc/haskell-dyre/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

