#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 equivalence
version:              0.3.5
visibility:           public
id:                   equivalence-0.3.5-BDQilWRI5uSJWH6HKtucGO
key:                  equivalence-0.3.5-BDQilWRI5uSJWH6HKtucGO
license:              BSD-3-Clause
maintainer:           paba@itu.dk
author:               Patrick Bahr
stability:            provisional
homepage:             https://github.com/pa-ba/equivalence
synopsis:
    Maintaining an equivalence relation implemented as union-find using STT.

description:
    This is an implementation of Tarjan'\''s Union-Find algorithm (Robert
    E. Tarjan. "Efficiency of a Good But Not Linear Set Union
    Algorithm", JACM 22(2), 1975) in order to maintain an equivalence
    relation.
    This implementation is a port of the /union-find/ package using the
    ST monad transformer (instead of the IO monad).

category:             Algorithms, Data
abi:                  0d7af126087495cf69e9086034b55a48
exposed:              True
exposed-modules:      Data.Equivalence.Monad Data.Equivalence.STT
import-dirs:          /usr/lib/ghc-9.0.1/site-local/equivalence-0.3.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/equivalence-0.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/equivalence-0.3.5
hs-libraries:         HSequivalence-0.3.5-BDQilWRI5uSJWH6HKtucGO
depends:
    STMonadTrans-0.4.6-1p78vGbf0GxJe2KC1dgJCL base-4.15.0.0
    containers-0.6.4.1 mtl-2.2.2 transformers-0.5.6.2
    transformers-compat-0.7.1-27E2wCklav6CMkj1Ns7rzE

haddock-interfaces:   /usr/share/doc/haskell-equivalence/html/equivalence.haddock
haddock-html:         /usr/share/doc/haskell-equivalence/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

