#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 esqueleto
version:              3.5.2.1
visibility:           public
id:                   esqueleto-3.5.2.1-3qhl51gVRxO4UFXqjSqRS3
key:                  esqueleto-3.5.2.1-3qhl51gVRxO4UFXqjSqRS3
license:              BSD-3-Clause
copyright:            (c) 2012-2016 Felipe Almeida Lessa
maintainer:           cma@bitemyapp.com
author:               Felipe Lessa
homepage:             https://github.com/bitemyapp/esqueleto
synopsis:             Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries that works with unmodified @persistent@ SQL backends.  Its language closely resembles SQL, so you don'\''t have to learn new concepts, just new syntax, and it'\''s fairly easy to predict the generated SQL and optimize it for your backend. Most kinds of errors committed when writing SQL are caught as compile-time errors---although it is possible to write type-checked @esqueleto@ queries that fail at runtime.

    @persistent@ is a library for type-safe data serialization.  It has many kinds of backends, such as SQL backends (@persistent-mysql@, @persistent-postgresql@, @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@). While @persistent@ is a nice library for storing and retrieving records, including with filters, it does not try to support some of the features that are specific to SQL backends.  In particular, @esqueleto@ is the recommended library for type-safe @JOIN@s on @persistent@ SQL backends.  (The alternative is using raw SQL, but that'\''s error prone and does not offer any composability.)

    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported. Not all SQL features are available, but most of them can be easily added (especially functions), so please open an issue or send a pull request if you need anything that is not covered by @esqueleto@ on <https://github.com/bitemyapp/esqueleto>.

    The name of this library means \"skeleton\" in Portuguese and contains all three SQL letters in the correct order =).  It was inspired by Scala'\''s Squeryl but created from scratch.

category:             Database
abi:                  c6a55771565134410e84b04e68cad8a1
exposed:              True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Experimental
    Database.Esqueleto.Experimental.From
    Database.Esqueleto.Experimental.From.CommonTableExpression
    Database.Esqueleto.Experimental.From.Join
    Database.Esqueleto.Experimental.From.SqlSetOperation
    Database.Esqueleto.Experimental.ToAlias
    Database.Esqueleto.Experimental.ToAliasReference
    Database.Esqueleto.Experimental.ToMaybe
    Database.Esqueleto.Internal.ExprParser
    Database.Esqueleto.Internal.Internal Database.Esqueleto.Legacy
    Database.Esqueleto.MySQL Database.Esqueleto.PostgreSQL
    Database.Esqueleto.PostgreSQL.JSON Database.Esqueleto.SQLite

hidden-modules:
    Database.Esqueleto.PostgreSQL.JSON.Instances
    Database.Esqueleto.Internal.PersistentImport Paths_esqueleto

import-dirs:          /usr/lib/ghc-9.0.1/site-local/esqueleto-3.5.2.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/esqueleto-3.5.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/esqueleto-3.5.2.1
hs-libraries:         HSesqueleto-3.5.2.1-3qhl51gVRxO4UFXqjSqRS3
depends:
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    blaze-html-0.9.1.2-K4t4PnwLIn1K06QqwerVVe bytestring-0.10.12.1
    conduit-1.3.4.2-AchFtERdZ63E4BSigaitpI containers-0.6.4.1
    monad-logger-0.3.36-7VH6RM5TTQQCholvAXCufw
    persistent-2.13.1.2-EmR9JXxoN8NHRt4RYgE77F
    resourcet-1.2.4.3-DSdH8WNuZw9AkjYvTicAaV
    tagged-0.8.6.1-FL843C40q4d1DeuwYADr25 text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2 unliftio-0.2.20-3mGFrmsbPJ1E5EBhNtXPag
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu

haddock-interfaces:   /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html:         /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

