#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 free
version:              5.1.7
visibility:           public
id:                   free-5.1.7-FWBUU8xEKPX4Q9z8pw5z7Z
key:                  free-5.1.7-FWBUU8xEKPX4Q9z8pw5z7Z
license:              BSD-3-Clause
copyright:            Copyright (C) 2008-2015 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/free/
synopsis:             Monads for free
description:
    Free monads are useful for many tree-like structures and domain specific languages.

    If @f@ is a '\''Functor'\'' then the free '\''Monad'\'' on @f@ is the type
    of trees whose nodes are labeled with the constructors of @f@. The word
    \"free\" is used in the sense of \"unrestricted\" rather than \"zero-cost\":
    @Free f@ makes no constraining assumptions beyond those given by @f@ and the
    definition of '\''Monad'\''. As used here it is a standard term from the
    mathematical theory of adjoint functors.

    Cofree comonads are dual to free monads. They provide convenient ways to talk
    about branching streams and rose-trees, and can be used to annotate syntax
    trees. The cofree comonad can be seen as a stream parameterized by a '\''Functor'\''
    that controls its branching factor.

    More information on free monads, including examples, can be found in the
    following blog posts:
    <http://comonad.com/reader/2008/monads-for-free/>
    <http://comonad.com/reader/2011/free-monads-for-less/>

category:             Control, Monads
abi:                  46387e6e6adf9581e36521e25bbf6ef9
exposed:              True
exposed-modules:
    Control.Alternative.Free Control.Alternative.Free.Final
    Control.Applicative.Free Control.Applicative.Free.Fast
    Control.Applicative.Free.Final Control.Applicative.Trans.Free
    Control.Comonad.Cofree Control.Comonad.Cofree.Class
    Control.Comonad.Trans.Cofree Control.Comonad.Trans.Coiter
    Control.Monad.Free Control.Monad.Free.Ap Control.Monad.Free.Church
    Control.Monad.Free.Class Control.Monad.Free.TH
    Control.Monad.Trans.Free Control.Monad.Trans.Free.Ap
    Control.Monad.Trans.Free.Church Control.Monad.Trans.Iter

hidden-modules:       Data.Functor.Classes.Compat
import-dirs:          /usr/lib/ghc-9.0.1/site-local/free-5.1.7
library-dirs:         /usr/lib/ghc-9.0.1/site-local/free-5.1.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/free-5.1.7
hs-libraries:         HSfree-5.1.7-FWBUU8xEKPX4Q9z8pw5z7Z
includes:             free-common.h
depends:
    base-4.15.0.0 comonad-5.0.8-FQMHC8Di1aZAOXOGXELcFI
    containers-0.6.4.1 distributive-0.6.2.1-Am5w0QbIYNjCC0H1ExagzD
    exceptions-0.10.4 indexed-traversable-0.1.1-K0YsJRCif6Q7nMYcYE7GvA
    mtl-2.2.2 profunctors-5.6.2-BCER5gcx0SlDcSUAEwXMiO
    semigroupoids-5.3.6-8YyLw1xUGcxBRUiDY7goKe
    template-haskell-2.17.0.0
    th-abstraction-0.4.3.0-DBpnRpG8EZgFebz88L1kOA transformers-0.5.6.2
    transformers-base-0.4.6-FnmENEsvcCW4yNlDEn2XlP

haddock-interfaces:   /usr/share/doc/haskell-free/html/free.haddock
haddock-html:         /usr/share/doc/haskell-free/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

