#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ghc-exactprint
version:              0.6.4
visibility:           public
id:                   ghc-exactprint-0.6.4-9TwOd8WPowIFvEKFh1hUBa
key:                  ghc-exactprint-0.6.4-9TwOd8WPowIFvEKFh1hUBa
license:              BSD-3-Clause
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman, Matthew Pickering
synopsis:             ExactPrint for GHC
description:
    Using the API Annotations available from GHC 7.10.2, this
    library provides a means to round trip any code that can
    be compiled by GHC, currently excluding lhs files.

    It does this with a phased approach

    * Delta - converts GHC API Annotations into relative
    offsets, indexed by SrcSpan

    * Transform - functions to facilitate changes to
    the AST, adjusting the annotations generated in the
    Delta phase to suit the changes.

    * Print - converts an AST and its annotations to
    properly formatted source text.

    * Pretty - adds annotations to an AST (fragment) so that
    the output can be parsed back to the same AST.


    Note: requires GHC 7.10.2 or later

category:             Development
abi:                  5447234f66a987b0551633422abc2b16
exposed:              True
exposed-modules:
    Language.Haskell.GHC.ExactPrint
    Language.Haskell.GHC.ExactPrint.Annotate
    Language.Haskell.GHC.ExactPrint.AnnotateTypes
    Language.Haskell.GHC.ExactPrint.Annotater
    Language.Haskell.GHC.ExactPrint.Delta
    Language.Haskell.GHC.ExactPrint.Lookup
    Language.Haskell.GHC.ExactPrint.Parsers
    Language.Haskell.GHC.ExactPrint.Preprocess
    Language.Haskell.GHC.ExactPrint.Pretty
    Language.Haskell.GHC.ExactPrint.Print
    Language.Haskell.GHC.ExactPrint.Transform
    Language.Haskell.GHC.ExactPrint.Types
    Language.Haskell.GHC.ExactPrint.Utils

import-dirs:          /usr/lib/ghc-9.0.1/site-local/ghc-exactprint-0.6.4
library-dirs:         /usr/lib/ghc-9.0.1/site-local/ghc-exactprint-0.6.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/ghc-exactprint-0.6.4
hs-libraries:         HSghc-exactprint-0.6.4-9TwOd8WPowIFvEKFh1hUBa
depends:
    base-4.15.0.0 bytestring-0.10.12.1 containers-0.6.4.1
    directory-1.3.6.1 filepath-1.4.2.1
    free-5.1.7-FWBUU8xEKPX4Q9z8pw5z7Z ghc-9.0.1 ghc-boot-9.0.1
    ghc-paths-0.1.0.12-D0EghxpsajHHuX2KoHY7KF mtl-2.2.2
    syb-0.7.2.1-JG4kH6P0JxMKeIFdjWhhC8

haddock-interfaces:
    /usr/share/doc/haskell-ghc-exactprint/html/ghc-exactprint.haddock

haddock-html:         /usr/share/doc/haskell-ghc-exactprint/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

