#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ghc-typelits-natnormalise
version:              0.7.6
visibility:           public
id:                   ghc-typelits-natnormalise-0.7.6-CX5GdXkZxBv6P4PbepuCpT
key:                  ghc-typelits-natnormalise-0.7.6-CX5GdXkZxBv6P4PbepuCpT
license:              BSD-2-Clause
copyright:
    Copyright © 2015-2016, University of Twente,
    2017-2018, QBayLogic B.V.

maintainer:           christiaan.baaij@gmail.com
author:               Christiaan Baaij
homepage:             http://www.clash-lang.org/
synopsis:             GHC typechecker plugin for types of kind GHC.TypeLits.Nat
description:
    A type checker plugin for GHC that can solve /equalities/ and /inequalities/
    of types of kind @Nat@, where these types are either:

    * Type-level naturals

    * Type variables

    * Applications of the arithmetic expressions @(+,-,*,^)@.

    It solves these equalities by normalising them to /sort-of/ @SOP@
    (Sum-of-Products) form, and then perform a simple syntactic equality.

    For example, this solver can prove the equality between:

    @
    (x + 2)^(y + 2)
    @

    and

    @
    4*x*(2 + x)^y + 4*(2 + x)^y + (2 + x)^y*x^2
    @

    Because the latter is actually the @SOP@ normal form of the former.

    To use the plugin, add the

    @
    OPTIONS_GHC -fplugin GHC.TypeLits.Normalise
    @

    Pragma to the header of your file.

category:             Type System
abi:                  0b068982654d152c14968e08c1f88da2
exposed:              True
exposed-modules:
    GHC.TypeLits.Normalise GHC.TypeLits.Normalise.SOP
    GHC.TypeLits.Normalise.Unify

import-dirs:
    /usr/lib/ghc-9.0.1/site-local/ghc-typelits-natnormalise-0.7.6

library-dirs:
    /usr/lib/ghc-9.0.1/site-local/ghc-typelits-natnormalise-0.7.6

dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/ghc-typelits-natnormalise-0.7.6

hs-libraries:         HSghc-typelits-natnormalise-0.7.6-CX5GdXkZxBv6P4PbepuCpT
depends:
    base-4.15.0.0 containers-0.6.4.1 ghc-9.0.1 ghc-bignum-1.0
    ghc-tcplugins-extra-0.4.2-3VinaHsf0sUJgY9DXcGjHV
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-ghc-typelits-natnormalise/html/ghc-typelits-natnormalise.haddock

haddock-html:         /usr/share/doc/haskell-ghc-typelits-natnormalise/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

