#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hOpenPGP
version:              2.9.5
visibility:           public
id:                   hOpenPGP-2.9.5-3vahPMlDn2NBzbQTZMjpMW
key:                  hOpenPGP-2.9.5-3vahPMlDn2NBzbQTZMjpMW
license:              MIT
copyright:            2012-2020  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  4ce180111c154629bf5a7dc5680def37
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher

import-dirs:          /usr/lib/ghc-9.0.1/site-local/hOpenPGP-2.9.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/hOpenPGP-2.9.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/hOpenPGP-2.9.5
hs-libraries:         HShOpenPGP-2.9.5-3vahPMlDn2NBzbQTZMjpMW
depends:
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    asn1-encoding-0.9.6-1hiEaDzNnvZCKkl9Gb4izO
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    base16-bytestring-1.0.1.0-GJhpZd6NgioKWj3pmrwD4Y
    bifunctors-5.5.11-3MgHowlkzBNDa84Pzdaw4w binary-0.8.8.0
    binary-conduit-1.3.1-6l7A2HRbOxA9ojnLLpSxj0 bytestring-0.10.12.1
    bz2-1.0.1.0-EthReVa6eFqGPNfXtGP816
    conduit-1.3.4.2-AchFtERdZ63E4BSigaitpI
    conduit-extra-1.3.5-IgmaX557TTAKniYRnNEHGm containers-0.6.4.1
    crypto-cipher-types-0.0.9-2oAnHtqeRctAMvgq4mBtVl
    cryptonite-0.29-19SjDRwWNox27CMfesQpq4
    errors-2.3.0-FhBmHY7sMIf8wTT2E4ozOx
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    incremental-parser-0.5.0.2-F7mdUnLLywE9yFglrKJiJJ
    ixset-typed-0.5-IklnrIag0Ec3hllzCRVdbf
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO
    memory-0.16.0-CGaPOmXCTce28vOCDDnDFr
    monad-loops-0.4.3-CoSqVlGqFyAAyK5Lg2m9AJ
    nettle-0.3.0-LBTadu1XgKbBXssreAKwoe
    network-uri-2.6.4.1-32se5oU1b9O36LNwPHSlHj
    openpgp-asciiarmor-0.1.2-BlE1V7azQhcLVqkbxv7Hep
    prettyprinter-1.7.1-163EeBePjHLIFZcbZybr4n
    resourcet-1.2.4.3-DSdH8WNuZw9AkjYvTicAaV
    split-0.2.3.4-DqRCEXcI8QnJvOh9Kk2yn3 text-1.2.4.1 time-1.9.3
    time-locale-compat-0.1.1.5-HOIeHz8A3IdD2UbO8b27LU
    transformers-0.5.6.2 unliftio-core-0.2.0.1-2baD1vXgUkB5a1NRn2rSLN
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    zlib-0.6.2.3-E9uJMwS6YgyGpbwvTurPgU

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

