#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 http-client-restricted
version:              0.0.4
visibility:           public
id:                   http-client-restricted-0.0.4-G3Y5hrvuFUmGRdY3hOrlUR
key:                  http-client-restricted-0.0.4-G3Y5hrvuFUmGRdY3hOrlUR
license:              MIT
copyright:            2018 Joey Hess, 2013 Michael Snoyman
maintainer:           Joey Hess <id@joeyh.name>
author:               Joey Hess
synopsis:             restricting the servers that http-client will use
description:
    Addition to the http-client and http-client-tls
    libraries, that restricts the HTTP servers that can be used.

    This is useful when a security policy needs to eg, prevent connections to
    HTTP servers on localhost or a local network, or only allow connections
    to a specific HTTP server.

    It handles restricting redirects as well as the initial HTTP connection,
    and it also guards against DNS poisoning attacks.

category:             Network
abi:                  9f839cdacb6b549479870cb78a4dd002
exposed:              True
exposed-modules:      Network.HTTP.Client.Restricted
import-dirs:          /usr/lib/ghc-9.0.1/site-local/http-client-restricted-0.0.4
library-dirs:         /usr/lib/ghc-9.0.1/site-local/http-client-restricted-0.0.4
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/http-client-restricted-0.0.4

hs-libraries:         HShttp-client-restricted-0.0.4-G3Y5hrvuFUmGRdY3hOrlUR
depends:
    base-4.15.0.0 connection-0.3.1-C12bY4xfmmQ2lLqBR677VO
    data-default-0.7.1.1-J3rzpkFy8Zd5Q7EBzVOXXF
    http-client-0.7.9-FqmYjByM3mW7WXdqjAmvxU
    http-client-tls-0.3.5.3-E3YrvnwOLk7FnDgjHH7fkr
    network-3.1.2.2-9BU8QqWnKeP98A8KvbSili
    network-bsd-2.8.1.0-8Vywqi148Vt7dDkmuIyhq2
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf

haddock-interfaces:
    /usr/share/doc/haskell-http-client-restricted/html/http-client-restricted.haddock

haddock-html:         /usr/share/doc/haskell-http-client-restricted/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

