#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hyphenation
version:              0.8.2
visibility:           public
id:                   hyphenation-0.8.2-4NnxMVXrVL7A31ZQS0JBmf
key:                  hyphenation-0.8.2-4NnxMVXrVL7A31ZQS0JBmf
license:              BSD-2-Clause
copyright:            (C) 2012-2019 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/hyphenation
synopsis:             Configurable Knuth-Liang hyphenation
description:
    Configurable Knuth-Liang hyphenation

    Uses the UTF8 encoded hyphenation patterns provided by
    hyph-utf8 from
    <http://www.ctan.org/tex-archive/language/hyph-utf8>

    Usage:

    >>> hyphenate english_US "supercalifragilisticexpialadocious"
    ["su","per","cal","ifrag","ilis","tic","ex","pi","al","ado","cious"]

    >>> hyphenate english_US "hyphenation"
    ["hy","phen","ation"]

    >>> hyphenate icelandic "va\240lahei\240avegavinnuverkf\230rageymslusk\250r"
    ["va\240la","hei\240a","vega","vinnu","verk","f\230ra","geymslu","sk\250r"]

category:             Text
abi:                  05e436711a728ad6c11830679d0693c8
exposed:              True
exposed-modules:
    Text.Hyphenation Text.Hyphenation.Exception
    Text.Hyphenation.Hyphenator Text.Hyphenation.Language
    Text.Hyphenation.Pattern

hidden-modules:
    Text.Hyphenation.ByteStringLazyCompat Paths_hyphenation

import-dirs:          /usr/lib/ghc-9.0.1/site-local/hyphenation-0.8.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/hyphenation-0.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/hyphenation-0.8.2
hs-libraries:         HShyphenation-0.8.2-4NnxMVXrVL7A31ZQS0JBmf
depends:
    base-4.15.0.0 bytestring-0.10.12.1 containers-0.6.4.1
    file-embed-0.0.14.0-DpVDNlFaM0M9fTuZiTfuRf text-1.2.4.1
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    zlib-0.6.2.3-E9uJMwS6YgyGpbwvTurPgU

haddock-interfaces:   /usr/share/doc/haskell-hyphenation/html/hyphenation.haddock
haddock-html:         /usr/share/doc/haskell-hyphenation/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

