#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 integer-roots
version:              1.0.0.1
visibility:           public
id:                   integer-roots-1.0.0.1-4dwUYgzeE5Q63oS5kedKX
key:                  integer-roots-1.0.0.1-4dwUYgzeE5Q63oS5kedKX
license:              MIT
copyright:            (c) 2011 Daniel Fischer, 2016-2020 Andrew Lelechenko.
maintainer:           Andrew Lelechenko andrew dot lelechenko at gmail dot com
author:               Daniel Fischer, Andrew Lelechenko
homepage:             https://github.com/Bodigrim/integer-roots
synopsis:             Integer roots and perfect powers
description:
    Calculating integer roots and testing perfect powers of arbitrary precision. Originally part of <https://hackage.haskell.org/package/arithmoi arithmoi> package.

category:             Math, Algorithms, Number Theory
abi:                  f5d5ac689527d24d43d0d69a93ba1bb4
exposed:              True
exposed-modules:      Math.NumberTheory.Roots
hidden-modules:
    Math.NumberTheory.Primes.Small Math.NumberTheory.Roots.Cubes
    Math.NumberTheory.Roots.Fourth Math.NumberTheory.Roots.General
    Math.NumberTheory.Roots.Squares
    Math.NumberTheory.Roots.Squares.Internal
    Math.NumberTheory.Utils.BitMask
    Math.NumberTheory.Utils.FromIntegral

import-dirs:          /usr/lib/ghc-9.0.1/site-local/integer-roots-1.0.0.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/integer-roots-1.0.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/integer-roots-1.0.0.1
hs-libraries:         HSinteger-roots-1.0.0.1-4dwUYgzeE5Q63oS5kedKX
depends:              base-4.15.0.0 integer-gmp-1.1
haddock-interfaces:
    /usr/share/doc/haskell-integer-roots/html/integer-roots.haddock

haddock-html:         /usr/share/doc/haskell-integer-roots/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

