#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 jose
version:              0.8.5
visibility:           public
id:                   jose-0.8.5-1lRjkWdKGCOFP7Un6y9hCN
key:                  jose-0.8.5-1lRjkWdKGCOFP7Un6y9hCN
license:              Apache-2.0
copyright:            Copyright (C) 2013-2018  Fraser Tweedale
maintainer:           frase@frase.id.au
author:               Fraser Tweedale
homepage:             https://github.com/frasertweedale/hs-jose
synopsis:
    Javascript Object Signing and Encryption and JSON Web Token library

description:

    An implementation of the Javascript Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519) formats.

    The JSON Web Signature (JWS; RFC 7515) implementation is complete.

    EdDSA signatures (RFC 8037) are supported (Ed25519 only).

    JWK Thumbprint (RFC 7638) is supported.

    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.

    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.

category:             Cryptography
abi:                  c58bdcbad57a168f58e5fbbac66c3efc
exposed:              True
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT

hidden-modules:
    Crypto.JOSE.TH Crypto.JOSE.Types.Internal Crypto.JOSE.Types.Orphans

import-dirs:          /usr/lib/ghc-9.0.1/site-local/jose-0.8.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/jose-0.8.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/jose-0.8.5
hs-libraries:         HSjose-0.8.5-1lRjkWdKGCOFP7Un6y9hCN
depends:
    QuickCheck-2.14.2-Hi2DusSU1aNLBaKmssS2cn
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    base64-bytestring-1.2.1.0-BH3if0BufO51UJ74fSwj5E
    bytestring-0.10.12.1 concise-0.1.0.1-IzRJwLOcGE552C4QKnhopg
    containers-0.6.4.1 cryptonite-0.29-19SjDRwWNox27CMfesQpq4
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO
    memory-0.16.0-CGaPOmXCTce28vOCDDnDFr
    monad-time-0.3.1.0-4tLFe4CV0BOLalyGkEzbQ3 mtl-2.2.2
    network-uri-2.6.4.1-32se5oU1b9O36LNwPHSlHj
    quickcheck-instances-0.3.25.2-IK8SwWmrJuB8yqjbpWXvF1
    safe-0.3.19-BCcHjTM7bV690cTfMWPidj template-haskell-2.17.0.0
    text-1.2.4.1 time-1.9.3
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3
    x509-1.7.5-KZBg6E9cDNpzkDdONM3tO

haddock-interfaces:   /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html:         /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

