#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 kvitable
version:              1.0.0.0
visibility:           public
id:                   kvitable-1.0.0.0-IbxTT5GiEWN3m9gAfblOoB
key:                  kvitable-1.0.0.0-IbxTT5GiEWN3m9gAfblOoB
license:              ISC
copyright:            Kevin Quick, 2021
maintainer:           kquick@galois.com
author:               Kevin Quick
synopsis:             Key/Value Indexed Table container and formatting library
description:

    Allows creation of a table from a set of of Key+Value Indices.
    This differs from the standard '\''Map'\'' structure in that the '\''Map'\''
    simply indexes by value but the KVI table indexes by a
    heterogeneous list of keys along with their associated values.
    This effectively creates an N-dimensional table, where
    @N=Product(Count(Values[key]))@.  The table contents can be sparse.

    This library also provides the ability to format multi-dimensional
    data in a table presentation.  The table is automatically formatted
    and can be output in a number of different styles (ascii, html,
    etc.)

    Multi-dimensional data is more difficult to represent than simple
    two-dimensional data; this package provides the ability to select
    which dimensions should be represented as sub-rows and which
    dimensions should be represented as sub-columns.  See the README
    for examples

category:             Text
abi:                  4317a239cedf1db19272101530b6fe3f
exposed:              True
exposed-modules:
    Data.KVITable Data.KVITable.Render Data.KVITable.Render.ASCII
    Data.KVITable.Render.HTML

import-dirs:          /usr/lib/ghc-9.0.1/site-local/kvitable-1.0.0.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/kvitable-1.0.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/kvitable-1.0.0.0
hs-libraries:         HSkvitable-1.0.0.0-IbxTT5GiEWN3m9gAfblOoB
depends:
    base-4.15.0.0 containers-0.6.4.1
    lucid-2.9.12.1-ElUJ01wTTH05DhClcgeKdU
    microlens-0.4.12.0-IoK2ncpVKVzEwRUasmz5D3
    prettyprinter-1.7.1-163EeBePjHLIFZcbZybr4n text-1.2.4.1

haddock-interfaces:   /usr/share/doc/haskell-kvitable/html/kvitable.haddock
haddock-html:         /usr/share/doc/haskell-kvitable/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

