#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 language-c
version:              0.9.0.1
visibility:           public
id:                   language-c-0.9.0.1-1WNc9REfLzcu0zMJrfAe5
key:                  language-c-0.9.0.1-1WNc9REfLzcu0zMJrfAe5
license:              BSD-3-Clause
copyright:            LICENSE
maintainer:           language.c@monoid.al
author:               AUTHORS
stability:            experimental
homepage:             http://visq.github.io/language-c/
synopsis:             Analysis and generation of C code
description:
    Language C is a haskell library for the analysis and generation of C code.
    It features a complete, well tested parser and pretty printer for all of C99 and a large
    set of C11 and clang/GNU extensions.

category:             Language
abi:                  f8b5cdbe0cc941d002736672f9d9f233
exposed:              True
exposed-modules:
    Language.C Language.C.Analysis Language.C.Analysis.AstAnalysis
    Language.C.Analysis.Builtins Language.C.Analysis.ConstEval
    Language.C.Analysis.Debug Language.C.Analysis.DeclAnalysis
    Language.C.Analysis.DefTable Language.C.Analysis.Export
    Language.C.Analysis.MachineDescs Language.C.Analysis.NameSpaceMap
    Language.C.Analysis.SemError Language.C.Analysis.SemRep
    Language.C.Analysis.TravMonad Language.C.Analysis.TypeCheck
    Language.C.Analysis.TypeConversions Language.C.Analysis.TypeUtils
    Language.C.Data Language.C.Data.Error Language.C.Data.Ident
    Language.C.Data.InputStream Language.C.Data.Name
    Language.C.Data.Node Language.C.Data.Position Language.C.Parser
    Language.C.Pretty Language.C.Syntax Language.C.Syntax.AST
    Language.C.Syntax.Constants Language.C.Syntax.Ops
    Language.C.Syntax.Utils Language.C.System.GCC
    Language.C.System.Preprocess

hidden-modules:
    Language.C.Data.RList Language.C.Parser.Builtin
    Language.C.Parser.Lexer Language.C.Parser.ParserMonad
    Language.C.Parser.Tokens Language.C.Parser.Parser

import-dirs:          /usr/lib/ghc-9.0.1/site-local/language-c-0.9.0.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/language-c-0.9.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/language-c-0.9.0.1
hs-libraries:         HSlanguage-c-0.9.0.1-1WNc9REfLzcu0zMJrfAe5
depends:
    array-0.5.4.0 base-4.15.0.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.1 filepath-1.4.2.1 mtl-2.2.2
    pretty-1.1.3.6 process-1.6.11.0

haddock-interfaces:   /usr/share/doc/haskell-language-c/html/language-c.haddock
haddock-html:         /usr/share/doc/haskell-language-c/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

