#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ListLike
version:              4.7.6
visibility:           public
id:                   ListLike-4.7.6-BPpkDqWOjQgJj2Ma9tJMP
key:                  ListLike-4.7.6-BPpkDqWOjQgJj2Ma9tJMP
license:              BSD-3-Clause
copyright:            Copyright (c) 2007-2008 John Goerzen
maintainer:           David Fox <dsf@seereason.com>, Andreas Abel
author:               John Goerzen
stability:            Stable
homepage:             http://github.com/ddssff/listlike
synopsis:             Generalized support for list-like structures
description:
    Generalized support for list-like structures in Haskell.

    The ListLike module provides a common interface to the various Haskell
    types that are list-like.  Predefined interfaces include standard
    Haskell lists, Arrays, ByteStrings, and lazy ByteStrings.  Custom
    types can easily be made ListLike instances as well.

    ListLike also provides for String-like types, such as String and
    ByteString, for types that support input and output, and for types that can handle
    infinite lists.

category:             list, string, text, bytestring, vector
abi:                  6b21c4351b594cd5e78aea7ae8b644d6
exposed:              True
exposed-modules:
    Data.ListLike Data.ListLike.Base Data.ListLike.CharString
    Data.ListLike.Chars Data.ListLike.DList Data.ListLike.FMList
    Data.ListLike.FoldableLL Data.ListLike.IO Data.ListLike.Instances
    Data.ListLike.String Data.ListLike.Text Data.ListLike.Text.Builder
    Data.ListLike.Text.Text Data.ListLike.Text.TextLazy
    Data.ListLike.UTF8 Data.ListLike.Utils Data.ListLike.Vector
    Data.ListLike.Vector.Generic Data.ListLike.Vector.Storable
    Data.ListLike.Vector.Unboxed Data.ListLike.Vector.Vector

import-dirs:          /usr/lib/ghc-9.0.1/site-local/ListLike-4.7.6
library-dirs:         /usr/lib/ghc-9.0.1/site-local/ListLike-4.7.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/ListLike-4.7.6
hs-libraries:         HSListLike-4.7.6-BPpkDqWOjQgJj2Ma9tJMP
depends:
    array-0.5.4.0 base-4.15.0.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 dlist-1.0-UyN3fdgb0F8e8xXMrElbD
    fmlist-0.9.4-8bpLqUePgN09k8x4ia8meY text-1.2.4.1
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:   /usr/share/doc/haskell-listlike/html/ListLike.haddock
haddock-html:         /usr/share/doc/haskell-listlike/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

