#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp
version:              1.2.0.1
visibility:           public
id:                   lsp-1.2.0.1-2mclQUhAQLH12mhQtTde8R
key:                  lsp-1.2.0.1-2mclQUhAQLH12mhQtTde8R
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  b09a40ee3021e0d30496db6d71a62a72
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.0.1/site-local/lsp-1.2.0.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/lsp-1.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/lsp-1.2.0.1
hs-libraries:         HSlsp-1.2.0.1-2mclQUhAQLH12mhQtTde8R
depends:
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    async-2.2.3-IdiNIvUG6Je7aMAPJeWE0D
    attoparsec-0.14.1-2NPvvgp5QbjKeCRmapAgpC base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1
    data-default-0.7.1.1-J3rzpkFy8Zd5Q7EBzVOXXF
    dependent-map-0.4.0.0-2QUt6o63X2vDfxm6UE5Psc exceptions-0.10.4
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    hslogger-1.3.1.0-CHuLQIhxTKX2AjBndY1AIo
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO
    lsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd mtl-2.2.2
    network-uri-2.6.4.1-32se5oU1b9O36LNwPHSlHj
    random-1.2.1-AVlrOvJdpabLt5UKQZGZvR
    scientific-0.3.7.0-LvVousZ2ZB29j7oXDdeCGV
    sorted-list-0.2.1.0-GAuY2s8imm748N24vRN1OU stm-2.5.0.0 text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2
    unliftio-core-0.2.0.1-2baD1vXgUkB5a1NRn2rSLN
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    uuid-1.3.15-KvcbvB71W377mxUBX2XOE7

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

