#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp-test
version:              0.14.0.1
visibility:           public
id:                   lsp-test-0.14.0.1-GHKJKHmp2lI5oKGFP0GG5H
key:                  lsp-test-0.14.0.1-GHKJKHmp2lI5oKGFP0GG5H
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  f9876f23643e8d6f500862b855ecd806
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-5jHqYWwdpCqFWQLuYLRvi6:Control.Applicative.Combinators,
    Language.LSP.Test,
    Language.LSP.Types from lsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd:Language.LSP.Types.Capabilities

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.0.1/site-local/lsp-test-0.14.0.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/lsp-test-0.14.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/lsp-test-0.14.0.1
hs-libraries:         HSlsp-test-0.14.0.1-GHKJKHmp2lI5oKGFP0GG5H
depends:
    Diff-0.4.0-F7vyJzYzam9CwrUJdg8bD2
    Glob-0.10.2-5LcO2uvmVkiLj5mcG3if5b
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S
    aeson-pretty-0.8.9-AXFdNE1ZWy326pjreSMahS
    ansi-terminal-0.11-Kvq5JBN7BE16HA1JfrRBzw
    async-2.2.3-IdiNIvUG6Je7aMAPJeWE0D base-4.15.0.0
    bytestring-0.10.12.1 conduit-1.3.4.2-AchFtERdZ63E4BSigaitpI
    conduit-parse-0.2.1.0-FQwiSBb3wjW1aztpQGH5Ct containers-0.6.4.1
    data-default-0.7.1.1-J3rzpkFy8Zd5Q7EBzVOXXF directory-1.3.6.1
    filepath-1.4.2.1 lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO
    lsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd mtl-2.2.2
    parser-combinators-1.3.0-5jHqYWwdpCqFWQLuYLRvi6 process-1.6.11.0
    some-1.0.3-7sghqqTkEQg7XqQ206Tg1F text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

