#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp-types
version:              1.3.0.1
visibility:           public
id:                   lsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd
key:                  lsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:
    Haskell library for the Microsoft Language Server Protocol, data types

description:
    An implementation of the types to allow language implementors to
    support the Language Server Protocol for their specific language.

category:             Development
abi:                  cc1471383c69e06178d3ade928ec089b
exposed:              True
exposed-modules:
    Data.IxMap Language.LSP.Types Language.LSP.Types.Capabilities
    Language.LSP.Types.Lens Language.LSP.VFS

hidden-modules:
    Language.LSP.Types.CallHierarchy Language.LSP.Types.Cancellation
    Language.LSP.Types.ClientCapabilities Language.LSP.Types.CodeAction
    Language.LSP.Types.CodeLens Language.LSP.Types.Command
    Language.LSP.Types.Common Language.LSP.Types.Completion
    Language.LSP.Types.Configuration Language.LSP.Types.Declaration
    Language.LSP.Types.Definition Language.LSP.Types.Diagnostic
    Language.LSP.Types.DocumentColor Language.LSP.Types.DocumentFilter
    Language.LSP.Types.DocumentHighlight
    Language.LSP.Types.DocumentLink Language.LSP.Types.DocumentSymbol
    Language.LSP.Types.FoldingRange Language.LSP.Types.Formatting
    Language.LSP.Types.Hover Language.LSP.Types.Implementation
    Language.LSP.Types.Initialize Language.LSP.Types.Location
    Language.LSP.Types.LspId Language.LSP.Types.MarkupContent
    Language.LSP.Types.Method Language.LSP.Types.Message
    Language.LSP.Types.Parsing Language.LSP.Types.Progress
    Language.LSP.Types.Registration Language.LSP.Types.References
    Language.LSP.Types.Rename Language.LSP.Types.SelectionRange
    Language.LSP.Types.ServerCapabilities
    Language.LSP.Types.SemanticTokens Language.LSP.Types.SignatureHelp
    Language.LSP.Types.StaticRegistrationOptions
    Language.LSP.Types.TextDocument Language.LSP.Types.TypeDefinition
    Language.LSP.Types.Uri Language.LSP.Types.Utils
    Language.LSP.Types.Window Language.LSP.Types.WatchedFiles
    Language.LSP.Types.WorkspaceEdit
    Language.LSP.Types.WorkspaceFolders
    Language.LSP.Types.WorkspaceSymbol

import-dirs:          /usr/lib/ghc-9.0.1/site-local/lsp-types-1.3.0.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/lsp-types-1.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/lsp-types-1.3.0.1
hs-libraries:         HSlsp-types-1.3.0.1-FPj1At5aiRI1oEashLCBdd
depends:
    Diff-0.4.0-F7vyJzYzam9CwrUJdg8bD2
    aeson-1.5.6.0-6DdSUx8dbuIIjP00Zg5a6S base-4.15.0.0 binary-0.8.8.0
    bytestring-0.10.12.1 containers-0.6.4.1
    data-default-0.7.1.1-J3rzpkFy8Zd5Q7EBzVOXXF deepseq-1.4.5.0
    dependent-sum-0.7.1.0-AV8oTxF478P2wjsyWt3Sel
    dependent-sum-template-0.1.0.3-CSdmq4qAYGWCvJvllauVmU
    directory-1.3.6.1 dlist-1.0-UyN3fdgb0F8e8xXMrElbD filepath-1.4.2.1
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH
    hslogger-1.3.1.0-CHuLQIhxTKX2AjBndY1AIo
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO mtl-2.2.2
    network-uri-2.6.4.1-32se5oU1b9O36LNwPHSlHj
    rope-utf16-splay-0.3.2.0-1dlg0ep1KMG5fWXKE68xDp
    scientific-0.3.7.0-LvVousZ2ZB29j7oXDdeCGV
    some-1.0.3-7sghqqTkEQg7XqQ206Tg1F template-haskell-2.17.0.0
    temporary-1.3-1fpZ6Xm8biD79YIGypkFzm text-1.2.4.1
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu

haddock-interfaces:   /usr/share/doc/haskell-lsp-types/html/lsp-types.haddock
haddock-html:         /usr/share/doc/haskell-lsp-types/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

